# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.suggested_issue import SuggestedIssue
from typing import Optional, Set
from typing_extensions import Self

class IssuePickerSuggestionsIssueType(BaseModel):
    """
    A type of issue suggested for use in auto-completion.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The ID of the type of issues suggested for use in auto-completion.")
    issues: Optional[List[SuggestedIssue]] = Field(default=None, description="A list of issues suggested for use in auto-completion.")
    label: Optional[StrictStr] = Field(default=None, description="The label of the type of issues suggested for use in auto-completion.")
    msg: Optional[StrictStr] = Field(default=None, description="If no issue suggestions are found, returns a message indicating no suggestions were found,")
    sub: Optional[StrictStr] = Field(default=None, description="If issue suggestions are found, returns a message indicating the number of issues suggestions found and returned.")
    __properties: ClassVar[List[str]] = ["id", "issues", "label", "msg", "sub"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuePickerSuggestionsIssueType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "issues",
            "label",
            "msg",
            "sub",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issues (list)
        _items = []
        if self.issues:
            for _item_issues in self.issues:
                if _item_issues:
                    _items.append(_item_issues.to_dict())
            _dict['issues'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuePickerSuggestionsIssueType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "issues": [SuggestedIssue.from_dict(_item) for _item in obj["issues"]] if obj.get("issues") is not None else None,
            "label": obj.get("label"),
            "msg": obj.get("msg"),
            "sub": obj.get("sub")
        })
        return _obj


