# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.field_metadata import FieldMetadata
from devopso.clients.jira_cloud.models.status_details import StatusDetails
from typing import Optional, Set
from typing_extensions import Self

class IssueTransition(BaseModel):
    """
    Details of an issue transition.
    """ # noqa: E501
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional transition details in the response.")
    fields: Optional[Dict[str, FieldMetadata]] = Field(default=None, description="Details of the fields associated with the issue transition screen. Use this information to populate `fields` and `update` in a transition request.")
    has_screen: Optional[StrictBool] = Field(default=None, description="Whether there is a screen associated with the issue transition.", alias="hasScreen")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the issue transition. Required when specifying a transition to undertake.")
    is_available: Optional[StrictBool] = Field(default=None, description="Whether the transition is available to be performed.", alias="isAvailable")
    is_conditional: Optional[StrictBool] = Field(default=None, description="Whether the issue has to meet criteria before the issue transition is applied.", alias="isConditional")
    is_global: Optional[StrictBool] = Field(default=None, description="Whether the issue transition is global, that is, the transition is applied to issues regardless of their status.", alias="isGlobal")
    is_initial: Optional[StrictBool] = Field(default=None, description="Whether this is the initial issue transition for the workflow.", alias="isInitial")
    looped: Optional[StrictBool] = None
    name: Optional[StrictStr] = Field(default=None, description="The name of the issue transition.")
    to: Optional[StatusDetails] = Field(default=None, description="Details of the issue status after the transition.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["expand", "fields", "hasScreen", "id", "isAvailable", "isConditional", "isGlobal", "isInitial", "looped", "name", "to"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTransition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "expand",
            "fields",
            "has_screen",
            "is_available",
            "is_conditional",
            "is_global",
            "is_initial",
            "name",
            "to",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in fields (dict)
        _field_dict = {}
        if self.fields:
            for _key_fields in self.fields:
                if self.fields[_key_fields]:
                    _field_dict[_key_fields] = self.fields[_key_fields].to_dict()
            _dict['fields'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of to
        if self.to:
            _dict['to'] = self.to.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTransition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "expand": obj.get("expand"),
            "fields": dict(
                (_k, FieldMetadata.from_dict(_v))
                for _k, _v in obj["fields"].items()
            )
            if obj.get("fields") is not None
            else None,
            "hasScreen": obj.get("hasScreen"),
            "id": obj.get("id"),
            "isAvailable": obj.get("isAvailable"),
            "isConditional": obj.get("isConditional"),
            "isGlobal": obj.get("isGlobal"),
            "isInitial": obj.get("isInitial"),
            "looped": obj.get("looped"),
            "name": obj.get("name"),
            "to": StatusDetails.from_dict(obj["to"]) if obj.get("to") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


