# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from devopso.clients.jira_cloud.models.field_metadata import FieldMetadata
from devopso.clients.jira_cloud.models.scope import Scope
from typing import Optional, Set
from typing_extensions import Self

class IssueTypeIssueCreateMetadata(BaseModel):
    """
    Details of the issue creation metadata for an issue type.
    """ # noqa: E501
    avatar_id: Optional[StrictInt] = Field(default=None, description="The ID of the issue type's avatar.", alias="avatarId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the issue type.")
    entity_id: Optional[UUID] = Field(default=None, description="Unique ID for next-gen projects.", alias="entityId")
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional issue type metadata details in the response.")
    fields: Optional[Dict[str, FieldMetadata]] = Field(default=None, description="List of the fields available when creating an issue for the issue type.")
    hierarchy_level: Optional[StrictInt] = Field(default=None, description="Hierarchy level of the issue type.", alias="hierarchyLevel")
    icon_url: Optional[StrictStr] = Field(default=None, description="The URL of the issue type's avatar.", alias="iconUrl")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the issue type.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the issue type.")
    scope: Optional[Scope] = Field(default=None, description="Details of the next-gen projects the issue type is available in.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of these issue type details.", alias="self")
    subtask: Optional[StrictBool] = Field(default=None, description="Whether this issue type is used to create subtasks.")
    __properties: ClassVar[List[str]] = ["avatarId", "description", "entityId", "expand", "fields", "hierarchyLevel", "iconUrl", "id", "name", "scope", "self", "subtask"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTypeIssueCreateMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "avatar_id",
            "description",
            "entity_id",
            "expand",
            "fields",
            "hierarchy_level",
            "icon_url",
            "id",
            "name",
            "scope",
            "var_self",
            "subtask",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in fields (dict)
        _field_dict = {}
        if self.fields:
            for _key_fields in self.fields:
                if self.fields[_key_fields]:
                    _field_dict[_key_fields] = self.fields[_key_fields].to_dict()
            _dict['fields'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTypeIssueCreateMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatarId": obj.get("avatarId"),
            "description": obj.get("description"),
            "entityId": obj.get("entityId"),
            "expand": obj.get("expand"),
            "fields": dict(
                (_k, FieldMetadata.from_dict(_v))
                for _k, _v in obj["fields"].items()
            )
            if obj.get("fields") is not None
            else None,
            "hierarchyLevel": obj.get("hierarchyLevel"),
            "iconUrl": obj.get("iconUrl"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "scope": Scope.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "self": obj.get("self"),
            "subtask": obj.get("subtask")
        })
        return _obj


