# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_type_hierarchy_payload import IssueTypeHierarchyPayload
from devopso.clients.jira_cloud.models.issue_type_payload import IssueTypePayload
from devopso.clients.jira_cloud.models.issue_type_scheme_payload import IssueTypeSchemePayload
from typing import Optional, Set
from typing_extensions import Self

class IssueTypeProjectCreatePayload(BaseModel):
    """
    The payload for creating issue types in a project
    """ # noqa: E501
    issue_type_hierarchy: Optional[List[Optional[IssueTypeHierarchyPayload]]] = Field(default=None, description="Defines the issue type hierarhy to be created and used during this project creation. This will only add new levels if there isn't an existing level", alias="issueTypeHierarchy")
    issue_type_scheme: Optional[IssueTypeSchemePayload] = Field(default=None, alias="issueTypeScheme")
    issue_types: Optional[List[Optional[IssueTypePayload]]] = Field(default=None, description="Only needed if you want to create issue types, you can otherwise use the ids of issue types in the scheme configuration", alias="issueTypes")
    __properties: ClassVar[List[str]] = ["issueTypeHierarchy", "issueTypeScheme", "issueTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTypeProjectCreatePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issue_type_hierarchy (list)
        _items = []
        if self.issue_type_hierarchy:
            for _item_issue_type_hierarchy in self.issue_type_hierarchy:
                if _item_issue_type_hierarchy:
                    _items.append(_item_issue_type_hierarchy.to_dict())
            _dict['issueTypeHierarchy'] = _items
        # override the default output from pydantic by calling `to_dict()` of issue_type_scheme
        if self.issue_type_scheme:
            _dict['issueTypeScheme'] = self.issue_type_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in issue_types (list)
        _items = []
        if self.issue_types:
            for _item_issue_types in self.issue_types:
                if _item_issue_types:
                    _items.append(_item_issue_types.to_dict())
            _dict['issueTypes'] = _items
        # set to None if issue_type_hierarchy (nullable) is None
        # and model_fields_set contains the field
        if self.issue_type_hierarchy is None and "issue_type_hierarchy" in self.model_fields_set:
            _dict['issueTypeHierarchy'] = None

        # set to None if issue_types (nullable) is None
        # and model_fields_set contains the field
        if self.issue_types is None and "issue_types" in self.model_fields_set:
            _dict['issueTypes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTypeProjectCreatePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issueTypeHierarchy": [IssueTypeHierarchyPayload.from_dict(_item) for _item in obj["issueTypeHierarchy"]] if obj.get("issueTypeHierarchy") is not None else None,
            "issueTypeScheme": IssueTypeSchemePayload.from_dict(obj["issueTypeScheme"]) if obj.get("issueTypeScheme") is not None else None,
            "issueTypes": [IssueTypePayload.from_dict(_item) for _item in obj["issueTypes"]] if obj.get("issueTypes") is not None else None
        })
        return _obj


