# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IssueTypeSchemeDetails(BaseModel):
    """
    Details of an issue type scheme and its associated issue types.
    """ # noqa: E501
    default_issue_type_id: Optional[StrictStr] = Field(default=None, description="The ID of the default issue type of the issue type scheme. This ID must be included in `issueTypeIds`.", alias="defaultIssueTypeId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the issue type scheme. The maximum length is 4000 characters.")
    issue_type_ids: List[StrictStr] = Field(description="The list of issue types IDs of the issue type scheme. At least one standard issue type ID is required.", alias="issueTypeIds")
    name: StrictStr = Field(description="The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.")
    __properties: ClassVar[List[str]] = ["defaultIssueTypeId", "description", "issueTypeIds", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTypeSchemeDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTypeSchemeDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultIssueTypeId": obj.get("defaultIssueTypeId"),
            "description": obj.get("description"),
            "issueTypeIds": obj.get("issueTypeIds"),
            "name": obj.get("name")
        })
        return _obj


