# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_type_screen_scheme_mapping import IssueTypeScreenSchemeMapping
from typing import Optional, Set
from typing_extensions import Self

class IssueTypeScreenSchemeDetails(BaseModel):
    """
    The details of an issue type screen scheme.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the issue type screen scheme. The maximum length is 255 characters.")
    issue_type_mappings: List[IssueTypeScreenSchemeMapping] = Field(description="The IDs of the screen schemes for the issue type IDs and *default*. A *default* entry is required to create an issue type screen scheme, it defines the mapping for all issue types without a screen scheme.", alias="issueTypeMappings")
    name: StrictStr = Field(description="The name of the issue type screen scheme. The name must be unique. The maximum length is 255 characters.")
    __properties: ClassVar[List[str]] = ["description", "issueTypeMappings", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTypeScreenSchemeDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issue_type_mappings (list)
        _items = []
        if self.issue_type_mappings:
            for _item_issue_type_mappings in self.issue_type_mappings:
                if _item_issue_type_mappings:
                    _items.append(_item_issue_type_mappings.to_dict())
            _dict['issueTypeMappings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTypeScreenSchemeDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "issueTypeMappings": [IssueTypeScreenSchemeMapping.from_dict(_item) for _item in obj["issueTypeMappings"]] if obj.get("issueTypeMappings") is not None else None,
            "name": obj.get("name")
        })
        return _obj


