# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from devopso.clients.jira_cloud.models.issue_type_screen_scheme import IssueTypeScreenScheme
from typing import Optional, Set
from typing_extensions import Self

class IssueTypeScreenSchemesProjects(BaseModel):
    """
    Issue type screen scheme with a list of the projects that use it.
    """ # noqa: E501
    issue_type_screen_scheme: IssueTypeScreenScheme = Field(description="Details of an issue type screen scheme.", alias="issueTypeScreenScheme")
    project_ids: List[StrictStr] = Field(description="The IDs of the projects using the issue type screen scheme.", alias="projectIds")
    __properties: ClassVar[List[str]] = ["issueTypeScreenScheme", "projectIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTypeScreenSchemesProjects from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of issue_type_screen_scheme
        if self.issue_type_screen_scheme:
            _dict['issueTypeScreenScheme'] = self.issue_type_screen_scheme.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTypeScreenSchemesProjects from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issueTypeScreenScheme": IssueTypeScreenScheme.from_dict(obj["issueTypeScreenScheme"]) if obj.get("issueTypeScreenScheme") is not None else None,
            "projectIds": obj.get("projectIds")
        })
        return _obj


