# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IssueTypesWorkflowMapping(BaseModel):
    """
    Details about the mapping between issue types and a workflow.
    """ # noqa: E501
    default_mapping: Optional[StrictBool] = Field(default=None, description="Whether the workflow is the default workflow for the workflow scheme.", alias="defaultMapping")
    issue_types: Optional[List[StrictStr]] = Field(default=None, description="The list of issue type IDs.", alias="issueTypes")
    update_draft_if_needed: Optional[StrictBool] = Field(default=None, description="Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new workflow-issue types mapping. Defaults to `false`.", alias="updateDraftIfNeeded")
    workflow: Optional[StrictStr] = Field(default=None, description="The name of the workflow. Optional if updating the workflow-issue types mapping.")
    __properties: ClassVar[List[str]] = ["defaultMapping", "issueTypes", "updateDraftIfNeeded", "workflow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueTypesWorkflowMapping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueTypesWorkflowMapping from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultMapping": obj.get("defaultMapping"),
            "issueTypes": obj.get("issueTypes"),
            "updateDraftIfNeeded": obj.get("updateDraftIfNeeded"),
            "workflow": obj.get("workflow")
        })
        return _obj


