# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.entity_property import EntityProperty
from devopso.clients.jira_cloud.models.field_update_operation import FieldUpdateOperation
from devopso.clients.jira_cloud.models.history_metadata import HistoryMetadata
from devopso.clients.jira_cloud.models.issue_transition import IssueTransition
from typing import Optional, Set
from typing_extensions import Self

class IssueUpdateDetails(BaseModel):
    """
    Details of an issue update request.
    """ # noqa: E501
    fields: Optional[Dict[str, Any]] = Field(default=None, description="List of issue screen fields to update, specifying the sub-field to update and its value for each field. This field provides a straightforward option when setting a sub-field. When multiple sub-fields or other operations are required, use `update`. Fields included in here cannot be included in `update`.")
    history_metadata: Optional[HistoryMetadata] = Field(default=None, description="Additional issue history details.", alias="historyMetadata")
    properties: Optional[List[EntityProperty]] = Field(default=None, description="Details of issue properties to be add or update.")
    transition: Optional[IssueTransition] = Field(default=None, description="Details of a transition. Required when performing a transition, optional when creating or editing an issue.")
    update: Optional[Dict[str, List[FieldUpdateOperation]]] = Field(default=None, description="A Map containing the field field name and a list of operations to perform on the issue screen field. Note that fields included in here cannot be included in `fields`.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["fields", "historyMetadata", "properties", "transition", "update"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueUpdateDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of history_metadata
        if self.history_metadata:
            _dict['historyMetadata'] = self.history_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['properties'] = _items
        # override the default output from pydantic by calling `to_dict()` of transition
        if self.transition:
            _dict['transition'] = self.transition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in update (dict of array)
        _field_dict_of_array = {}
        if self.update:
            for _key_update in self.update:
                if self.update[_key_update] is not None:
                    _field_dict_of_array[_key_update] = [
                        _item.to_dict() for _item in self.update[_key_update]
                    ]
            _dict['update'] = _field_dict_of_array
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueUpdateDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fields": obj.get("fields"),
            "historyMetadata": HistoryMetadata.from_dict(obj["historyMetadata"]) if obj.get("historyMetadata") is not None else None,
            "properties": [EntityProperty.from_dict(_item) for _item in obj["properties"]] if obj.get("properties") is not None else None,
            "transition": IssueTransition.from_dict(obj["transition"]) if obj.get("transition") is not None else None,
            "update": dict(
                (_k,
                        [FieldUpdateOperation.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("update", {}).items()
            )
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


