# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IssuesJqlMetaDataBean(BaseModel):
    """
    The description of the page of issues loaded by the provided JQL query.
    """ # noqa: E501
    count: StrictInt = Field(description="The number of issues that were loaded in this evaluation.")
    max_results: StrictInt = Field(description="The maximum number of issues that could be loaded in this evaluation.", alias="maxResults")
    start_at: StrictInt = Field(description="The index of the first issue.", alias="startAt")
    total_count: StrictInt = Field(description="The total number of issues the JQL returned.", alias="totalCount")
    validation_warnings: Optional[List[StrictStr]] = Field(default=None, description="Any warnings related to the JQL query. Present only if the validation mode was set to `warn`.", alias="validationWarnings")
    __properties: ClassVar[List[str]] = ["count", "maxResults", "startAt", "totalCount", "validationWarnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuesJqlMetaDataBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuesJqlMetaDataBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "count": obj.get("count"),
            "maxResults": obj.get("maxResults"),
            "startAt": obj.get("startAt"),
            "totalCount": obj.get("totalCount"),
            "validationWarnings": obj.get("validationWarnings")
        })
        return _obj


