# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.jira_expression_complexity import JiraExpressionComplexity
from devopso.clients.jira_cloud.models.jira_expression_validation_error import JiraExpressionValidationError
from typing import Optional, Set
from typing_extensions import Self

class JiraExpressionAnalysis(BaseModel):
    """
    Details about the analysed Jira expression.
    """ # noqa: E501
    complexity: Optional[JiraExpressionComplexity] = None
    errors: Optional[List[JiraExpressionValidationError]] = Field(default=None, description="A list of validation errors. Not included if the expression is valid.")
    expression: StrictStr = Field(description="The analysed expression.")
    type: Optional[StrictStr] = Field(default=None, description="EXPERIMENTAL. The inferred type of the expression.")
    valid: StrictBool = Field(description="Whether the expression is valid and the interpreter will evaluate it. Note that the expression may fail at runtime (for example, if it executes too many expensive operations).")
    __properties: ClassVar[List[str]] = ["complexity", "errors", "expression", "type", "valid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JiraExpressionAnalysis from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of complexity
        if self.complexity:
            _dict['complexity'] = self.complexity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JiraExpressionAnalysis from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "complexity": JiraExpressionComplexity.from_dict(obj["complexity"]) if obj.get("complexity") is not None else None,
            "errors": [JiraExpressionValidationError.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "expression": obj.get("expression"),
            "type": obj.get("type"),
            "valid": obj.get("valid")
        })
        return _obj


