# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.custom_context_variable import CustomContextVariable
from devopso.clients.jira_cloud.models.id_or_key_bean import IdOrKeyBean
from devopso.clients.jira_cloud.models.jexp_issues import JexpIssues
from typing import Optional, Set
from typing_extensions import Self

class JiraExpressionEvalContextBean(BaseModel):
    """
    JiraExpressionEvalContextBean
    """ # noqa: E501
    board: Optional[StrictInt] = Field(default=None, description="The ID of the board that is available under the `board` variable when evaluating the expression.")
    custom: Optional[List[CustomContextVariable]] = Field(default=None, description="Custom context variables and their types. These variable types are available for use in a custom context:   *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.  *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.  *  `json`: A JSON object containing custom content.  *  `list`: A JSON list of `user`, `issue`, or `json` variable types.")
    customer_request: Optional[StrictInt] = Field(default=None, description="The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.", alias="customerRequest")
    issue: Optional[IdOrKeyBean] = Field(default=None, description="The issue that is available under the `issue` variable when evaluating the expression.")
    issues: Optional[JexpIssues] = Field(default=None, description="The collection of issues that is available under the `issues` variable when evaluating the expression.")
    project: Optional[IdOrKeyBean] = Field(default=None, description="The project that is available under the `project` variable when evaluating the expression.")
    service_desk: Optional[StrictInt] = Field(default=None, description="The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.", alias="serviceDesk")
    sprint: Optional[StrictInt] = Field(default=None, description="The ID of the sprint that is available under the `sprint` variable when evaluating the expression.")
    __properties: ClassVar[List[str]] = ["board", "custom", "customerRequest", "issue", "issues", "project", "serviceDesk", "sprint"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JiraExpressionEvalContextBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom (list)
        _items = []
        if self.custom:
            for _item_custom in self.custom:
                if _item_custom:
                    _items.append(_item_custom.to_dict())
            _dict['custom'] = _items
        # override the default output from pydantic by calling `to_dict()` of issue
        if self.issue:
            _dict['issue'] = self.issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issues
        if self.issues:
            _dict['issues'] = self.issues.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JiraExpressionEvalContextBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "board": obj.get("board"),
            "custom": [CustomContextVariable.from_dict(_item) for _item in obj["custom"]] if obj.get("custom") is not None else None,
            "customerRequest": obj.get("customerRequest"),
            "issue": IdOrKeyBean.from_dict(obj["issue"]) if obj.get("issue") is not None else None,
            "issues": JexpIssues.from_dict(obj["issues"]) if obj.get("issues") is not None else None,
            "project": IdOrKeyBean.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "serviceDesk": obj.get("serviceDesk"),
            "sprint": obj.get("sprint")
        })
        return _obj


