# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from devopso.clients.jira_cloud.models.jira_expressions_complexity_value_bean import JiraExpressionsComplexityValueBean
from typing import Optional, Set
from typing_extensions import Self

class JiraExpressionsComplexityBean(BaseModel):
    """
    JiraExpressionsComplexityBean
    """ # noqa: E501
    beans: JiraExpressionsComplexityValueBean = Field(description="The number of Jira REST API beans returned in the response.")
    expensive_operations: JiraExpressionsComplexityValueBean = Field(description="The number of expensive operations executed while evaluating the expression. Expensive operations are those that load additional data, such as entity properties, comments, or custom fields.", alias="expensiveOperations")
    primitive_values: JiraExpressionsComplexityValueBean = Field(description="The number of primitive values returned in the response.", alias="primitiveValues")
    steps: JiraExpressionsComplexityValueBean = Field(description="The number of steps it took to evaluate the expression, where a step is a high-level operation performed by the expression. A step is an operation such as arithmetic, accessing a property, accessing a context variable, or calling a function.")
    __properties: ClassVar[List[str]] = ["beans", "expensiveOperations", "primitiveValues", "steps"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JiraExpressionsComplexityBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of beans
        if self.beans:
            _dict['beans'] = self.beans.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expensive_operations
        if self.expensive_operations:
            _dict['expensiveOperations'] = self.expensive_operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primitive_values
        if self.primitive_values:
            _dict['primitiveValues'] = self.primitive_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of steps
        if self.steps:
            _dict['steps'] = self.steps.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JiraExpressionsComplexityBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "beans": JiraExpressionsComplexityValueBean.from_dict(obj["beans"]) if obj.get("beans") is not None else None,
            "expensiveOperations": JiraExpressionsComplexityValueBean.from_dict(obj["expensiveOperations"]) if obj.get("expensiveOperations") is not None else None,
            "primitiveValues": JiraExpressionsComplexityValueBean.from_dict(obj["primitiveValues"]) if obj.get("primitiveValues") is not None else None,
            "steps": JiraExpressionsComplexityValueBean.from_dict(obj["steps"]) if obj.get("steps") is not None else None
        })
        return _obj


