# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.jira_cascading_select_field import JiraCascadingSelectField
from devopso.clients.jira_cloud.models.jira_color_field import JiraColorField
from devopso.clients.jira_cloud.models.jira_date_field import JiraDateField
from devopso.clients.jira_cloud.models.jira_date_time_field import JiraDateTimeField
from devopso.clients.jira_cloud.models.jira_duration_field import JiraDurationField
from devopso.clients.jira_cloud.models.jira_issue_type_field import JiraIssueTypeField
from devopso.clients.jira_cloud.models.jira_labels_field import JiraLabelsField
from devopso.clients.jira_cloud.models.jira_multi_select_component_field import JiraMultiSelectComponentField
from devopso.clients.jira_cloud.models.jira_multiple_group_picker_field import JiraMultipleGroupPickerField
from devopso.clients.jira_cloud.models.jira_multiple_select_field import JiraMultipleSelectField
from devopso.clients.jira_cloud.models.jira_multiple_select_user_picker_field import JiraMultipleSelectUserPickerField
from devopso.clients.jira_cloud.models.jira_multiple_version_picker_field import JiraMultipleVersionPickerField
from devopso.clients.jira_cloud.models.jira_number_field import JiraNumberField
from devopso.clients.jira_cloud.models.jira_priority_field import JiraPriorityField
from devopso.clients.jira_cloud.models.jira_rich_text_field import JiraRichTextField
from devopso.clients.jira_cloud.models.jira_single_group_picker_field import JiraSingleGroupPickerField
from devopso.clients.jira_cloud.models.jira_single_line_text_field import JiraSingleLineTextField
from devopso.clients.jira_cloud.models.jira_single_select_field import JiraSingleSelectField
from devopso.clients.jira_cloud.models.jira_single_select_user_picker_field import JiraSingleSelectUserPickerField
from devopso.clients.jira_cloud.models.jira_single_version_picker_field import JiraSingleVersionPickerField
from devopso.clients.jira_cloud.models.jira_status_input import JiraStatusInput
from devopso.clients.jira_cloud.models.jira_time_tracking_field import JiraTimeTrackingField
from devopso.clients.jira_cloud.models.jira_url_field import JiraUrlField
from typing import Optional, Set
from typing_extensions import Self

class JiraIssueFields(BaseModel):
    """
    JiraIssueFields
    """ # noqa: E501
    cascading_select_fields: Optional[List[JiraCascadingSelectField]] = Field(default=None, description="Add or clear a cascading select field:   *  To add, specify `optionId` for both parent and child.  *  To clear the child, set its `optionId` to null.  *  To clear both, set the parent's `optionId` to null.", alias="cascadingSelectFields")
    clearable_number_fields: Optional[List[JiraNumberField]] = Field(default=None, description="Add or clear a number field:   *  To add, specify a numeric `value`.  *  To clear, set `value` to `null`.", alias="clearableNumberFields")
    color_fields: Optional[List[JiraColorField]] = Field(default=None, description="Add or clear a color field:   *  To add, specify the color `name`. Available colors are: `purple`, `blue`, `green`, `teal`, `yellow`, `orange`, `grey`, `dark purple`, `dark blue`, `dark green`, `dark teal`, `dark yellow`, `dark orange`, `dark grey`.  *  To clear, set the color `name` to an empty string.", alias="colorFields")
    date_picker_fields: Optional[List[JiraDateField]] = Field(default=None, description="Add or clear a date picker field:   *  To add, specify the date in `d/mmm/yy` format or ISO format `dd-mm-yyyy`.  *  To clear, set `formattedDate` to an empty string.", alias="datePickerFields")
    date_time_picker_fields: Optional[List[JiraDateTimeField]] = Field(default=None, description="Add or clear the planned start date and time:   *  To add, specify the date and time in ISO format for `formattedDateTime`.  *  To clear, provide an empty string for `formattedDateTime`.", alias="dateTimePickerFields")
    issue_type: Optional[JiraIssueTypeField] = Field(default=None, description="Set the issue type field by providing an `issueTypeId`.", alias="issueType")
    labels_fields: Optional[List[JiraLabelsField]] = Field(default=None, description="Edit a labels field:   *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.  *  To clear labels, use the `REMOVE_ALL` option with an empty `labels` array.", alias="labelsFields")
    multiple_group_picker_fields: Optional[List[JiraMultipleGroupPickerField]] = Field(default=None, description="Add or clear a multi-group picker field:   *  To add groups, provide an array of groups with `groupName`s.  *  To clear all groups, use an empty `groups` array.", alias="multipleGroupPickerFields")
    multiple_select_clearable_user_picker_fields: Optional[List[JiraMultipleSelectUserPickerField]] = Field(default=None, description="Assign or unassign multiple users to/from a field:   *  To assign, provide an array of user `accountId`s.  *  To clear, set `users` to `null`.", alias="multipleSelectClearableUserPickerFields")
    multiple_select_fields: Optional[List[JiraMultipleSelectField]] = Field(default=None, description="Add or clear a multi-select field:   *  To add, provide an array of options with `optionId`s.  *  To clear, use an empty `options` array.", alias="multipleSelectFields")
    multiple_version_picker_fields: Optional[List[JiraMultipleVersionPickerField]] = Field(default=None, description="Edit a multi-version picker field like Fix Versions/Affects Versions:   *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.  *  To clear the field, use the `REMOVE_ALL` option with an empty `versions` array.", alias="multipleVersionPickerFields")
    multiselect_components: Optional[JiraMultiSelectComponentField] = Field(default=None, description="Edit a multi select components field:   *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.  *  To clear, use the `REMOVE_ALL` option with an empty `components` array.", alias="multiselectComponents")
    original_estimate_field: Optional[JiraDurationField] = Field(default=None, description="Edit the original estimate field.", alias="originalEstimateField")
    priority: Optional[JiraPriorityField] = Field(default=None, description="Set the priority of an issue by specifying a `priorityId`.")
    rich_text_fields: Optional[List[JiraRichTextField]] = Field(default=None, description="Add or clear a rich text field:   *  To add, provide `adfValue`. Note that rich text fields only support ADF values.  *  To clear, use an empty `richText` object.  For ADF format details, refer to: [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure).", alias="richTextFields")
    single_group_picker_fields: Optional[List[JiraSingleGroupPickerField]] = Field(default=None, description="Add or clear a single group picker field:   *  To add, specify the group with `groupName`.  *  To clear, set `groupName` to an empty string.", alias="singleGroupPickerFields")
    single_line_text_fields: Optional[List[JiraSingleLineTextField]] = Field(default=None, description="Add or clear a single line text field:   *  To add, provide the `text` value.  *  To clear, set `text` to an empty string.", alias="singleLineTextFields")
    single_select_clearable_user_picker_fields: Optional[List[JiraSingleSelectUserPickerField]] = Field(default=None, description="Edit assignment for single select user picker fields like Assignee/Reporter:   *  To assign an issue, specify the user's `accountId`.  *  To unassign an issue, set `user` to `null`.  *  For automatic assignment, set `accountId` to `-1`.", alias="singleSelectClearableUserPickerFields")
    single_select_fields: Optional[List[JiraSingleSelectField]] = Field(default=None, description="Add or clear a single select field:   *  To add, specify the option with an `optionId`.  *  To clear, pass an option with `optionId` as `-1`.", alias="singleSelectFields")
    single_version_picker_fields: Optional[List[JiraSingleVersionPickerField]] = Field(default=None, description="Add or clear a single version picker field:   *  To add, specify the version with a `versionId`.  *  To clear, set `versionId` to `-1`.", alias="singleVersionPickerFields")
    status: Optional[JiraStatusInput] = None
    time_tracking_field: Optional[JiraTimeTrackingField] = Field(default=None, description="Edit the time tracking field.", alias="timeTrackingField")
    url_fields: Optional[List[JiraUrlField]] = Field(default=None, description="Add or clear a URL field:   *  To add, provide the `url` with the desired URL value.  *  To clear, set `url` to an empty string.", alias="urlFields")
    __properties: ClassVar[List[str]] = ["cascadingSelectFields", "clearableNumberFields", "colorFields", "datePickerFields", "dateTimePickerFields", "issueType", "labelsFields", "multipleGroupPickerFields", "multipleSelectClearableUserPickerFields", "multipleSelectFields", "multipleVersionPickerFields", "multiselectComponents", "originalEstimateField", "priority", "richTextFields", "singleGroupPickerFields", "singleLineTextFields", "singleSelectClearableUserPickerFields", "singleSelectFields", "singleVersionPickerFields", "status", "timeTrackingField", "urlFields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JiraIssueFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cascading_select_fields (list)
        _items = []
        if self.cascading_select_fields:
            for _item_cascading_select_fields in self.cascading_select_fields:
                if _item_cascading_select_fields:
                    _items.append(_item_cascading_select_fields.to_dict())
            _dict['cascadingSelectFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in clearable_number_fields (list)
        _items = []
        if self.clearable_number_fields:
            for _item_clearable_number_fields in self.clearable_number_fields:
                if _item_clearable_number_fields:
                    _items.append(_item_clearable_number_fields.to_dict())
            _dict['clearableNumberFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in color_fields (list)
        _items = []
        if self.color_fields:
            for _item_color_fields in self.color_fields:
                if _item_color_fields:
                    _items.append(_item_color_fields.to_dict())
            _dict['colorFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in date_picker_fields (list)
        _items = []
        if self.date_picker_fields:
            for _item_date_picker_fields in self.date_picker_fields:
                if _item_date_picker_fields:
                    _items.append(_item_date_picker_fields.to_dict())
            _dict['datePickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in date_time_picker_fields (list)
        _items = []
        if self.date_time_picker_fields:
            for _item_date_time_picker_fields in self.date_time_picker_fields:
                if _item_date_time_picker_fields:
                    _items.append(_item_date_time_picker_fields.to_dict())
            _dict['dateTimePickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of issue_type
        if self.issue_type:
            _dict['issueType'] = self.issue_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels_fields (list)
        _items = []
        if self.labels_fields:
            for _item_labels_fields in self.labels_fields:
                if _item_labels_fields:
                    _items.append(_item_labels_fields.to_dict())
            _dict['labelsFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in multiple_group_picker_fields (list)
        _items = []
        if self.multiple_group_picker_fields:
            for _item_multiple_group_picker_fields in self.multiple_group_picker_fields:
                if _item_multiple_group_picker_fields:
                    _items.append(_item_multiple_group_picker_fields.to_dict())
            _dict['multipleGroupPickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in multiple_select_clearable_user_picker_fields (list)
        _items = []
        if self.multiple_select_clearable_user_picker_fields:
            for _item_multiple_select_clearable_user_picker_fields in self.multiple_select_clearable_user_picker_fields:
                if _item_multiple_select_clearable_user_picker_fields:
                    _items.append(_item_multiple_select_clearable_user_picker_fields.to_dict())
            _dict['multipleSelectClearableUserPickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in multiple_select_fields (list)
        _items = []
        if self.multiple_select_fields:
            for _item_multiple_select_fields in self.multiple_select_fields:
                if _item_multiple_select_fields:
                    _items.append(_item_multiple_select_fields.to_dict())
            _dict['multipleSelectFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in multiple_version_picker_fields (list)
        _items = []
        if self.multiple_version_picker_fields:
            for _item_multiple_version_picker_fields in self.multiple_version_picker_fields:
                if _item_multiple_version_picker_fields:
                    _items.append(_item_multiple_version_picker_fields.to_dict())
            _dict['multipleVersionPickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of multiselect_components
        if self.multiselect_components:
            _dict['multiselectComponents'] = self.multiselect_components.to_dict()
        # override the default output from pydantic by calling `to_dict()` of original_estimate_field
        if self.original_estimate_field:
            _dict['originalEstimateField'] = self.original_estimate_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priority
        if self.priority:
            _dict['priority'] = self.priority.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rich_text_fields (list)
        _items = []
        if self.rich_text_fields:
            for _item_rich_text_fields in self.rich_text_fields:
                if _item_rich_text_fields:
                    _items.append(_item_rich_text_fields.to_dict())
            _dict['richTextFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in single_group_picker_fields (list)
        _items = []
        if self.single_group_picker_fields:
            for _item_single_group_picker_fields in self.single_group_picker_fields:
                if _item_single_group_picker_fields:
                    _items.append(_item_single_group_picker_fields.to_dict())
            _dict['singleGroupPickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in single_line_text_fields (list)
        _items = []
        if self.single_line_text_fields:
            for _item_single_line_text_fields in self.single_line_text_fields:
                if _item_single_line_text_fields:
                    _items.append(_item_single_line_text_fields.to_dict())
            _dict['singleLineTextFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in single_select_clearable_user_picker_fields (list)
        _items = []
        if self.single_select_clearable_user_picker_fields:
            for _item_single_select_clearable_user_picker_fields in self.single_select_clearable_user_picker_fields:
                if _item_single_select_clearable_user_picker_fields:
                    _items.append(_item_single_select_clearable_user_picker_fields.to_dict())
            _dict['singleSelectClearableUserPickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in single_select_fields (list)
        _items = []
        if self.single_select_fields:
            for _item_single_select_fields in self.single_select_fields:
                if _item_single_select_fields:
                    _items.append(_item_single_select_fields.to_dict())
            _dict['singleSelectFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in single_version_picker_fields (list)
        _items = []
        if self.single_version_picker_fields:
            for _item_single_version_picker_fields in self.single_version_picker_fields:
                if _item_single_version_picker_fields:
                    _items.append(_item_single_version_picker_fields.to_dict())
            _dict['singleVersionPickerFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_tracking_field
        if self.time_tracking_field:
            _dict['timeTrackingField'] = self.time_tracking_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in url_fields (list)
        _items = []
        if self.url_fields:
            for _item_url_fields in self.url_fields:
                if _item_url_fields:
                    _items.append(_item_url_fields.to_dict())
            _dict['urlFields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JiraIssueFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cascadingSelectFields": [JiraCascadingSelectField.from_dict(_item) for _item in obj["cascadingSelectFields"]] if obj.get("cascadingSelectFields") is not None else None,
            "clearableNumberFields": [JiraNumberField.from_dict(_item) for _item in obj["clearableNumberFields"]] if obj.get("clearableNumberFields") is not None else None,
            "colorFields": [JiraColorField.from_dict(_item) for _item in obj["colorFields"]] if obj.get("colorFields") is not None else None,
            "datePickerFields": [JiraDateField.from_dict(_item) for _item in obj["datePickerFields"]] if obj.get("datePickerFields") is not None else None,
            "dateTimePickerFields": [JiraDateTimeField.from_dict(_item) for _item in obj["dateTimePickerFields"]] if obj.get("dateTimePickerFields") is not None else None,
            "issueType": JiraIssueTypeField.from_dict(obj["issueType"]) if obj.get("issueType") is not None else None,
            "labelsFields": [JiraLabelsField.from_dict(_item) for _item in obj["labelsFields"]] if obj.get("labelsFields") is not None else None,
            "multipleGroupPickerFields": [JiraMultipleGroupPickerField.from_dict(_item) for _item in obj["multipleGroupPickerFields"]] if obj.get("multipleGroupPickerFields") is not None else None,
            "multipleSelectClearableUserPickerFields": [JiraMultipleSelectUserPickerField.from_dict(_item) for _item in obj["multipleSelectClearableUserPickerFields"]] if obj.get("multipleSelectClearableUserPickerFields") is not None else None,
            "multipleSelectFields": [JiraMultipleSelectField.from_dict(_item) for _item in obj["multipleSelectFields"]] if obj.get("multipleSelectFields") is not None else None,
            "multipleVersionPickerFields": [JiraMultipleVersionPickerField.from_dict(_item) for _item in obj["multipleVersionPickerFields"]] if obj.get("multipleVersionPickerFields") is not None else None,
            "multiselectComponents": JiraMultiSelectComponentField.from_dict(obj["multiselectComponents"]) if obj.get("multiselectComponents") is not None else None,
            "originalEstimateField": JiraDurationField.from_dict(obj["originalEstimateField"]) if obj.get("originalEstimateField") is not None else None,
            "priority": JiraPriorityField.from_dict(obj["priority"]) if obj.get("priority") is not None else None,
            "richTextFields": [JiraRichTextField.from_dict(_item) for _item in obj["richTextFields"]] if obj.get("richTextFields") is not None else None,
            "singleGroupPickerFields": [JiraSingleGroupPickerField.from_dict(_item) for _item in obj["singleGroupPickerFields"]] if obj.get("singleGroupPickerFields") is not None else None,
            "singleLineTextFields": [JiraSingleLineTextField.from_dict(_item) for _item in obj["singleLineTextFields"]] if obj.get("singleLineTextFields") is not None else None,
            "singleSelectClearableUserPickerFields": [JiraSingleSelectUserPickerField.from_dict(_item) for _item in obj["singleSelectClearableUserPickerFields"]] if obj.get("singleSelectClearableUserPickerFields") is not None else None,
            "singleSelectFields": [JiraSingleSelectField.from_dict(_item) for _item in obj["singleSelectFields"]] if obj.get("singleSelectFields") is not None else None,
            "singleVersionPickerFields": [JiraSingleVersionPickerField.from_dict(_item) for _item in obj["singleVersionPickerFields"]] if obj.get("singleVersionPickerFields") is not None else None,
            "status": JiraStatusInput.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "timeTrackingField": JiraTimeTrackingField.from_dict(obj["timeTrackingField"]) if obj.get("timeTrackingField") is not None else None,
            "urlFields": [JiraUrlField.from_dict(_item) for _item in obj["urlFields"]] if obj.get("urlFields") is not None else None
        })
        return _obj


