# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.jira_label_properties_input_jackson1 import JiraLabelPropertiesInputJackson1
from devopso.clients.jira_cloud.models.jira_labels_input import JiraLabelsInput
from typing import Optional, Set
from typing_extensions import Self

class JiraLabelsField(BaseModel):
    """
    JiraLabelsField
    """ # noqa: E501
    bulk_edit_multi_select_field_option: StrictStr = Field(alias="bulkEditMultiSelectFieldOption")
    field_id: StrictStr = Field(alias="fieldId")
    label_properties: Optional[List[JiraLabelPropertiesInputJackson1]] = Field(default=None, alias="labelProperties")
    labels: List[JiraLabelsInput]
    __properties: ClassVar[List[str]] = ["bulkEditMultiSelectFieldOption", "fieldId", "labelProperties", "labels"]

    @field_validator('bulk_edit_multi_select_field_option')
    def bulk_edit_multi_select_field_option_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL']):
            raise ValueError("must be one of enum values ('ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JiraLabelsField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in label_properties (list)
        _items = []
        if self.label_properties:
            for _item_label_properties in self.label_properties:
                if _item_label_properties:
                    _items.append(_item_label_properties.to_dict())
            _dict['labelProperties'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JiraLabelsField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bulkEditMultiSelectFieldOption": obj.get("bulkEditMultiSelectFieldOption"),
            "fieldId": obj.get("fieldId"),
            "labelProperties": [JiraLabelPropertiesInputJackson1.from_dict(_item) for _item in obj["labelProperties"]] if obj.get("labelProperties") is not None else None,
            "labels": [JiraLabelsInput.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None
        })
        return _obj


