# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.workflow_preview_scope import WorkflowPreviewScope
from typing import Optional, Set
from typing_extensions import Self

class JiraWorkflowPreviewStatus(BaseModel):
    """
    Details of a status.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the status.")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the status.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the status.")
    raw_name: Optional[StrictStr] = Field(default=None, description="The raw name of the status.", alias="rawName")
    scope: Optional[WorkflowPreviewScope] = None
    status_category: Optional[StrictStr] = Field(default=None, description="The category of the status.", alias="statusCategory")
    status_reference: Optional[StrictStr] = Field(default=None, description="The reference of the status. Unique within this response but not guaranteed to be stable across requests.", alias="statusReference")
    __properties: ClassVar[List[str]] = ["description", "id", "name", "rawName", "scope", "statusCategory", "statusReference"]

    @field_validator('status_category')
    def status_category_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TODO', 'IN_PROGRESS', 'DONE']):
            raise ValueError("must be one of enum values ('TODO', 'IN_PROGRESS', 'DONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JiraWorkflowPreviewStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JiraWorkflowPreviewStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "rawName": obj.get("rawName"),
            "scope": WorkflowPreviewScope.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "statusCategory": obj.get("statusCategory"),
            "statusReference": obj.get("statusReference")
        })
        return _obj


