# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from devopso.clients.jira_cloud.models.field_changed_clause import FieldChangedClause
from devopso.clients.jira_cloud.models.field_value_clause import FieldValueClause
from devopso.clients.jira_cloud.models.field_was_clause import FieldWasClause
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

JQLQUERYCLAUSE_ANY_OF_SCHEMAS = ["CompoundClause", "FieldChangedClause", "FieldValueClause", "FieldWasClause"]

class JqlQueryClause(BaseModel):
    """
    A JQL query clause.
    """

    # data type: CompoundClause
    anyof_schema_1_validator: Optional[CompoundClause] = None
    # data type: FieldValueClause
    anyof_schema_2_validator: Optional[FieldValueClause] = None
    # data type: FieldWasClause
    anyof_schema_3_validator: Optional[FieldWasClause] = None
    # data type: FieldChangedClause
    anyof_schema_4_validator: Optional[FieldChangedClause] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[CompoundClause, FieldChangedClause, FieldValueClause, FieldWasClause]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "CompoundClause", "FieldChangedClause", "FieldValueClause", "FieldWasClause" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = JqlQueryClause.model_construct()
        error_messages = []
        # validate data type: CompoundClause
        if not isinstance(v, CompoundClause):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CompoundClause`")
        else:
            return v

        # validate data type: FieldValueClause
        if not isinstance(v, FieldValueClause):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldValueClause`")
        else:
            return v

        # validate data type: FieldWasClause
        if not isinstance(v, FieldWasClause):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldWasClause`")
        else:
            return v

        # validate data type: FieldChangedClause
        if not isinstance(v, FieldChangedClause):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FieldChangedClause`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in JqlQueryClause with anyOf schemas: CompoundClause, FieldChangedClause, FieldValueClause, FieldWasClause. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[CompoundClause] = None
        try:
            instance.actual_instance = CompoundClause.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[FieldValueClause] = None
        try:
            instance.actual_instance = FieldValueClause.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[FieldWasClause] = None
        try:
            instance.actual_instance = FieldWasClause.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[FieldChangedClause] = None
        try:
            instance.actual_instance = FieldChangedClause.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into JqlQueryClause with anyOf schemas: CompoundClause, FieldChangedClause, FieldValueClause, FieldWasClause. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CompoundClause, FieldChangedClause, FieldValueClause, FieldWasClause]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())

from devopso.clients.jira_cloud.models.compound_clause import CompoundClause
# TODO: Rewrite to not use raise_errors
JqlQueryClause.model_rebuild(raise_errors=False)

