# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.jql_query_field_entity_property import JqlQueryFieldEntityProperty
from typing import Optional, Set
from typing_extensions import Self

class JqlQueryField(BaseModel):
    """
    A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.
    """ # noqa: E501
    encoded_name: Optional[StrictStr] = Field(default=None, description="The encoded name of the field, which can be used directly in a JQL query.", alias="encodedName")
    name: StrictStr = Field(description="The name of the field.")
    var_property: Optional[List[JqlQueryFieldEntityProperty]] = Field(default=None, description="When the field refers to a value in an entity property, details of the entity property value.", alias="property")
    __properties: ClassVar[List[str]] = ["encodedName", "name", "property"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JqlQueryField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in var_property (list)
        _items = []
        if self.var_property:
            for _item_var_property in self.var_property:
                if _item_var_property:
                    _items.append(_item_var_property.to_dict())
            _dict['property'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JqlQueryField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "encodedName": obj.get("encodedName"),
            "name": obj.get("name"),
            "property": [JqlQueryFieldEntityProperty.from_dict(_item) for _item in obj["property"]] if obj.get("property") is not None else None
        })
        return _obj


