# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from devopso.clients.jira_cloud.models.function_operand import FunctionOperand
from devopso.clients.jira_cloud.models.keyword_operand import KeywordOperand
from devopso.clients.jira_cloud.models.value_operand import ValueOperand
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

JQLQUERYUNITARYOPERAND_ANY_OF_SCHEMAS = ["FunctionOperand", "KeywordOperand", "ValueOperand"]

class JqlQueryUnitaryOperand(BaseModel):
    """
    An operand that can be part of a list operand.
    """

    # data type: ValueOperand
    anyof_schema_1_validator: Optional[ValueOperand] = None
    # data type: FunctionOperand
    anyof_schema_2_validator: Optional[FunctionOperand] = None
    # data type: KeywordOperand
    anyof_schema_3_validator: Optional[KeywordOperand] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[FunctionOperand, KeywordOperand, ValueOperand]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "FunctionOperand", "KeywordOperand", "ValueOperand" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = JqlQueryUnitaryOperand.model_construct()
        error_messages = []
        # validate data type: ValueOperand
        if not isinstance(v, ValueOperand):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ValueOperand`")
        else:
            return v

        # validate data type: FunctionOperand
        if not isinstance(v, FunctionOperand):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FunctionOperand`")
        else:
            return v

        # validate data type: KeywordOperand
        if not isinstance(v, KeywordOperand):
            error_messages.append(f"Error! Input type `{type(v)}` is not `KeywordOperand`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in JqlQueryUnitaryOperand with anyOf schemas: FunctionOperand, KeywordOperand, ValueOperand. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ValueOperand] = None
        try:
            instance.actual_instance = ValueOperand.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[FunctionOperand] = None
        try:
            instance.actual_instance = FunctionOperand.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[KeywordOperand] = None
        try:
            instance.actual_instance = KeywordOperand.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into JqlQueryUnitaryOperand with anyOf schemas: FunctionOperand, KeywordOperand, ValueOperand. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], FunctionOperand, KeywordOperand, ValueOperand]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


