# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.field_reference_data import FieldReferenceData
from devopso.clients.jira_cloud.models.function_reference_data import FunctionReferenceData
from typing import Optional, Set
from typing_extensions import Self

class JQLReferenceData(BaseModel):
    """
    Lists of JQL reference data.
    """ # noqa: E501
    jql_reserved_words: Optional[List[StrictStr]] = Field(default=None, description="List of JQL query reserved words.", alias="jqlReservedWords")
    visible_field_names: Optional[List[FieldReferenceData]] = Field(default=None, description="List of fields usable in JQL queries.", alias="visibleFieldNames")
    visible_function_names: Optional[List[FunctionReferenceData]] = Field(default=None, description="List of functions usable in JQL queries.", alias="visibleFunctionNames")
    __properties: ClassVar[List[str]] = ["jqlReservedWords", "visibleFieldNames", "visibleFunctionNames"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JQLReferenceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in visible_field_names (list)
        _items = []
        if self.visible_field_names:
            for _item_visible_field_names in self.visible_field_names:
                if _item_visible_field_names:
                    _items.append(_item_visible_field_names.to_dict())
            _dict['visibleFieldNames'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in visible_function_names (list)
        _items = []
        if self.visible_function_names:
            for _item_visible_function_names in self.visible_function_names:
                if _item_visible_function_names:
                    _items.append(_item_visible_function_names.to_dict())
            _dict['visibleFunctionNames'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JQLReferenceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jqlReservedWords": obj.get("jqlReservedWords"),
            "visibleFieldNames": [FieldReferenceData.from_dict(_item) for _item in obj["visibleFieldNames"]] if obj.get("visibleFieldNames") is not None else None,
            "visibleFunctionNames": [FunctionReferenceData.from_dict(_item) for _item in obj["visibleFunctionNames"]] if obj.get("visibleFunctionNames") is not None else None
        })
        return _obj


