# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class JsonNode(BaseModel):
    """
    JsonNode
    """ # noqa: E501
    array: Optional[StrictBool] = None
    big_decimal: Optional[StrictBool] = Field(default=None, alias="bigDecimal")
    big_integer: Optional[StrictBool] = Field(default=None, alias="bigInteger")
    big_integer_value: Optional[StrictInt] = Field(default=None, alias="bigIntegerValue")
    binary: Optional[StrictBool] = None
    binary_value: Optional[List[Union[StrictBytes, StrictStr]]] = Field(default=None, alias="binaryValue")
    boolean: Optional[StrictBool] = None
    boolean_value: Optional[StrictBool] = Field(default=None, alias="booleanValue")
    container_node: Optional[StrictBool] = Field(default=None, alias="containerNode")
    decimal_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="decimalValue")
    double: Optional[StrictBool] = None
    double_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="doubleValue")
    elements: Optional[Dict[str, Any]] = None
    field_names: Optional[Dict[str, Any]] = Field(default=None, alias="fieldNames")
    fields: Optional[Dict[str, Any]] = None
    floating_point_number: Optional[StrictBool] = Field(default=None, alias="floatingPointNumber")
    int: Optional[StrictBool] = None
    int_value: Optional[StrictInt] = Field(default=None, alias="intValue")
    integral_number: Optional[StrictBool] = Field(default=None, alias="integralNumber")
    long: Optional[StrictBool] = None
    long_value: Optional[StrictInt] = Field(default=None, alias="longValue")
    missing_node: Optional[StrictBool] = Field(default=None, alias="missingNode")
    null: Optional[StrictBool] = None
    number: Optional[StrictBool] = None
    number_type: Optional[StrictStr] = Field(default=None, alias="numberType")
    number_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="numberValue")
    object: Optional[StrictBool] = None
    pojo: Optional[StrictBool] = None
    text_value: Optional[StrictStr] = Field(default=None, alias="textValue")
    textual: Optional[StrictBool] = None
    value_as_boolean: Optional[StrictBool] = Field(default=None, alias="valueAsBoolean")
    value_as_double: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="valueAsDouble")
    value_as_int: Optional[StrictInt] = Field(default=None, alias="valueAsInt")
    value_as_long: Optional[StrictInt] = Field(default=None, alias="valueAsLong")
    value_as_text: Optional[StrictStr] = Field(default=None, alias="valueAsText")
    value_node: Optional[StrictBool] = Field(default=None, alias="valueNode")
    __properties: ClassVar[List[str]] = ["array", "bigDecimal", "bigInteger", "bigIntegerValue", "binary", "binaryValue", "boolean", "booleanValue", "containerNode", "decimalValue", "double", "doubleValue", "elements", "fieldNames", "fields", "floatingPointNumber", "int", "intValue", "integralNumber", "long", "longValue", "missingNode", "null", "number", "numberType", "numberValue", "object", "pojo", "textValue", "textual", "valueAsBoolean", "valueAsDouble", "valueAsInt", "valueAsLong", "valueAsText", "valueNode"]

    @field_validator('number_type')
    def number_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['INT', 'LONG', 'BIG_INTEGER', 'FLOAT', 'DOUBLE', 'BIG_DECIMAL']):
            raise ValueError("must be one of enum values ('INT', 'LONG', 'BIG_INTEGER', 'FLOAT', 'DOUBLE', 'BIG_DECIMAL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JsonNode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JsonNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "array": obj.get("array"),
            "bigDecimal": obj.get("bigDecimal"),
            "bigInteger": obj.get("bigInteger"),
            "bigIntegerValue": obj.get("bigIntegerValue"),
            "binary": obj.get("binary"),
            "binaryValue": obj.get("binaryValue"),
            "boolean": obj.get("boolean"),
            "booleanValue": obj.get("booleanValue"),
            "containerNode": obj.get("containerNode"),
            "decimalValue": obj.get("decimalValue"),
            "double": obj.get("double"),
            "doubleValue": obj.get("doubleValue"),
            "elements": obj.get("elements"),
            "fieldNames": obj.get("fieldNames"),
            "fields": obj.get("fields"),
            "floatingPointNumber": obj.get("floatingPointNumber"),
            "int": obj.get("int"),
            "intValue": obj.get("intValue"),
            "integralNumber": obj.get("integralNumber"),
            "long": obj.get("long"),
            "longValue": obj.get("longValue"),
            "missingNode": obj.get("missingNode"),
            "null": obj.get("null"),
            "number": obj.get("number"),
            "numberType": obj.get("numberType"),
            "numberValue": obj.get("numberValue"),
            "object": obj.get("object"),
            "pojo": obj.get("pojo"),
            "textValue": obj.get("textValue"),
            "textual": obj.get("textual"),
            "valueAsBoolean": obj.get("valueAsBoolean"),
            "valueAsDouble": obj.get("valueAsDouble"),
            "valueAsInt": obj.get("valueAsInt"),
            "valueAsLong": obj.get("valueAsLong"),
            "valueAsText": obj.get("valueAsText"),
            "valueNode": obj.get("valueNode")
        })
        return _obj


