# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.field_last_used import FieldLastUsed
from devopso.clients.jira_cloud.models.json_type_bean import JsonTypeBean
from typing import Optional, Set
from typing_extensions import Self

class ModelField(BaseModel):
    """
    Details of a field.
    """ # noqa: E501
    contexts_count: Optional[StrictInt] = Field(default=None, description="Number of contexts where the field is used.", alias="contextsCount")
    description: Optional[StrictStr] = Field(default=None, description="The description of the field.")
    id: StrictStr = Field(description="The ID of the field.")
    is_locked: Optional[StrictBool] = Field(default=None, description="Whether the field is locked.", alias="isLocked")
    is_unscreenable: Optional[StrictBool] = Field(default=None, description="Whether the field is shown on screen or not.", alias="isUnscreenable")
    key: Optional[StrictStr] = Field(default=None, description="The key of the field.")
    last_used: Optional[FieldLastUsed] = Field(default=None, alias="lastUsed")
    name: StrictStr = Field(description="The name of the field.")
    projects_count: Optional[StrictInt] = Field(default=None, description="Number of projects where the field is used.", alias="projectsCount")
    var_schema: JsonTypeBean = Field(alias="schema")
    screens_count: Optional[StrictInt] = Field(default=None, description="Number of screens where the field is used.", alias="screensCount")
    searcher_key: Optional[StrictStr] = Field(default=None, description="The searcher key of the field. Returned for custom fields.", alias="searcherKey")
    stable_id: Optional[StrictStr] = Field(default=None, description="The stable ID of the field.", alias="stableId")
    type_display_name: Optional[StrictStr] = Field(default=None, description="The display name of the field type", alias="typeDisplayName")
    __properties: ClassVar[List[str]] = ["contextsCount", "description", "id", "isLocked", "isUnscreenable", "key", "lastUsed", "name", "projectsCount", "schema", "screensCount", "searcherKey", "stableId", "typeDisplayName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModelField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_used
        if self.last_used:
            _dict['lastUsed'] = self.last_used.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModelField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contextsCount": obj.get("contextsCount"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "isLocked": obj.get("isLocked"),
            "isUnscreenable": obj.get("isUnscreenable"),
            "key": obj.get("key"),
            "lastUsed": FieldLastUsed.from_dict(obj["lastUsed"]) if obj.get("lastUsed") is not None else None,
            "name": obj.get("name"),
            "projectsCount": obj.get("projectsCount"),
            "schema": JsonTypeBean.from_dict(obj["schema"]) if obj.get("schema") is not None else None,
            "screensCount": obj.get("screensCount"),
            "searcherKey": obj.get("searcherKey"),
            "stableId": obj.get("stableId"),
            "typeDisplayName": obj.get("typeDisplayName")
        })
        return _obj


