# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.notification_recipients import NotificationRecipients
from devopso.clients.jira_cloud.models.notification_recipients_restrictions import NotificationRecipientsRestrictions
from typing import Optional, Set
from typing_extensions import Self

class Notification(BaseModel):
    """
    Details about a notification.
    """ # noqa: E501
    html_body: Optional[StrictStr] = Field(default=None, description="The HTML body of the email notification for the issue.", alias="htmlBody")
    restrict: Optional[NotificationRecipientsRestrictions] = Field(default=None, description="Restricts the notifications to users with the specified permissions.")
    subject: Optional[StrictStr] = Field(default=None, description="The subject of the email notification for the issue. If this is not specified, then the subject is set to the issue key and summary.")
    text_body: Optional[StrictStr] = Field(default=None, description="The plain text body of the email notification for the issue.", alias="textBody")
    to: Optional[NotificationRecipients] = Field(default=None, description="The recipients of the email notification for the issue.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["htmlBody", "restrict", "subject", "textBody", "to"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Notification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of restrict
        if self.restrict:
            _dict['restrict'] = self.restrict.to_dict()
        # override the default output from pydantic by calling `to_dict()` of to
        if self.to:
            _dict['to'] = self.to.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Notification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "htmlBody": obj.get("htmlBody"),
            "restrict": NotificationRecipientsRestrictions.from_dict(obj["restrict"]) if obj.get("restrict") is not None else None,
            "subject": obj.get("subject"),
            "textBody": obj.get("textBody"),
            "to": NotificationRecipients.from_dict(obj["to"]) if obj.get("to") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


