# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.group_name import GroupName
from devopso.clients.jira_cloud.models.user_details import UserDetails
from typing import Optional, Set
from typing_extensions import Self

class NotificationRecipients(BaseModel):
    """
    Details of the users and groups to receive the notification.
    """ # noqa: E501
    assignee: Optional[StrictBool] = Field(default=None, description="Whether the notification should be sent to the issue's assignees.")
    group_ids: Optional[List[StrictStr]] = Field(default=None, description="List of groupIds to receive the notification.", alias="groupIds")
    groups: Optional[List[GroupName]] = Field(default=None, description="List of groups to receive the notification.")
    reporter: Optional[StrictBool] = Field(default=None, description="Whether the notification should be sent to the issue's reporter.")
    users: Optional[List[UserDetails]] = Field(default=None, description="List of users to receive the notification.")
    voters: Optional[StrictBool] = Field(default=None, description="Whether the notification should be sent to the issue's voters.")
    watchers: Optional[StrictBool] = Field(default=None, description="Whether the notification should be sent to the issue's watchers.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["assignee", "groupIds", "groups", "reporter", "users", "voters", "watchers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationRecipients from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationRecipients from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignee": obj.get("assignee"),
            "groupIds": obj.get("groupIds"),
            "groups": [GroupName.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "reporter": obj.get("reporter"),
            "users": [UserDetails.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "voters": obj.get("voters"),
            "watchers": obj.get("watchers")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


