# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.notification_scheme_event import NotificationSchemeEvent
from devopso.clients.jira_cloud.models.scope import Scope
from typing import Optional, Set
from typing_extensions import Self

class NotificationScheme(BaseModel):
    """
    Details about a notification scheme.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the notification scheme.")
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional notification scheme details in the response.")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the notification scheme.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the notification scheme.")
    notification_scheme_events: Optional[List[NotificationSchemeEvent]] = Field(default=None, description="The notification events and associated recipients.", alias="notificationSchemeEvents")
    projects: Optional[List[StrictInt]] = Field(default=None, description="The list of project IDs associated with the notification scheme.")
    scope: Optional[Scope] = Field(default=None, description="The scope of the notification scheme.")
    var_self: Optional[StrictStr] = Field(default=None, alias="self")
    __properties: ClassVar[List[str]] = ["description", "expand", "id", "name", "notificationSchemeEvents", "projects", "scope", "self"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationScheme from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in notification_scheme_events (list)
        _items = []
        if self.notification_scheme_events:
            for _item_notification_scheme_events in self.notification_scheme_events:
                if _item_notification_scheme_events:
                    _items.append(_item_notification_scheme_events.to_dict())
            _dict['notificationSchemeEvents'] = _items
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationScheme from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "expand": obj.get("expand"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "notificationSchemeEvents": [NotificationSchemeEvent.from_dict(_item) for _item in obj["notificationSchemeEvents"]] if obj.get("notificationSchemeEvents") is not None else None,
            "projects": obj.get("projects"),
            "scope": Scope.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "self": obj.get("self")
        })
        return _obj


