# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.notification_scheme_event_payload import NotificationSchemeEventPayload
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class NotificationSchemePayload(BaseModel):
    """
    The payload for creating a notification scheme. The user has to supply the ID for the default notification scheme. For CMP this is provided in the project payload and should be left empty, for TMP it's provided using this payload
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the notification scheme")
    name: Optional[StrictStr] = Field(default=None, description="The name of the notification scheme")
    notification_scheme_events: Optional[List[NotificationSchemeEventPayload]] = Field(default=None, description="The events and notifications for the notification scheme", alias="notificationSchemeEvents")
    on_conflict: Optional[StrictStr] = Field(default=None, description="The strategy to use when there is a conflict with an existing entity", alias="onConflict")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    __properties: ClassVar[List[str]] = ["description", "name", "notificationSchemeEvents", "onConflict", "pcri"]

    @field_validator('on_conflict')
    def on_conflict_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'USE', 'NEW']):
            raise ValueError("must be one of enum values ('FAIL', 'USE', 'NEW')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationSchemePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in notification_scheme_events (list)
        _items = []
        if self.notification_scheme_events:
            for _item_notification_scheme_events in self.notification_scheme_events:
                if _item_notification_scheme_events:
                    _items.append(_item_notification_scheme_events.to_dict())
            _dict['notificationSchemeEvents'] = _items
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationSchemePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "name": obj.get("name"),
            "notificationSchemeEvents": [NotificationSchemeEventPayload.from_dict(_item) for _item in obj["notificationSchemeEvents"]] if obj.get("notificationSchemeEvents") is not None else None,
            "onConflict": obj.get("onConflict"),
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None
        })
        return _obj


