# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.dashboard import Dashboard
from typing import Optional, Set
from typing_extensions import Self

class PageOfDashboards(BaseModel):
    """
    A page containing dashboard details.
    """ # noqa: E501
    dashboards: Optional[List[Dashboard]] = Field(default=None, description="List of dashboards.")
    max_results: Optional[StrictInt] = Field(default=None, description="The maximum number of results that could be on the page.", alias="maxResults")
    next: Optional[StrictStr] = Field(default=None, description="The URL of the next page of results, if any.")
    prev: Optional[StrictStr] = Field(default=None, description="The URL of the previous page of results, if any.")
    start_at: Optional[StrictInt] = Field(default=None, description="The index of the first item returned on the page.", alias="startAt")
    total: Optional[StrictInt] = Field(default=None, description="The number of results on the page.")
    __properties: ClassVar[List[str]] = ["dashboards", "maxResults", "next", "prev", "startAt", "total"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PageOfDashboards from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "dashboards",
            "max_results",
            "next",
            "prev",
            "start_at",
            "total",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dashboards (list)
        _items = []
        if self.dashboards:
            for _item_dashboards in self.dashboards:
                if _item_dashboards:
                    _items.append(_item_dashboards.to_dict())
            _dict['dashboards'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PageOfDashboards from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dashboards": [Dashboard.from_dict(_item) for _item in obj["dashboards"]] if obj.get("dashboards") is not None else None,
            "maxResults": obj.get("maxResults"),
            "next": obj.get("next"),
            "prev": obj.get("prev"),
            "startAt": obj.get("startAt"),
            "total": obj.get("total")
        })
        return _obj


