# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from devopso.clients.jira_cloud.models.share_permission import SharePermission
from typing import Optional, Set
from typing_extensions import Self

class PermissionDetails(BaseModel):
    """
    Details for permissions of shareable entities
    """ # noqa: E501
    edit_permissions: List[SharePermission] = Field(description="The edit permissions for the shareable entities.", alias="editPermissions")
    share_permissions: List[SharePermission] = Field(description="The share permissions for the shareable entities.", alias="sharePermissions")
    __properties: ClassVar[List[str]] = ["editPermissions", "sharePermissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PermissionDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in edit_permissions (list)
        _items = []
        if self.edit_permissions:
            for _item_edit_permissions in self.edit_permissions:
                if _item_edit_permissions:
                    _items.append(_item_edit_permissions.to_dict())
            _dict['editPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in share_permissions (list)
        _items = []
        if self.share_permissions:
            for _item_share_permissions in self.share_permissions:
                if _item_share_permissions:
                    _items.append(_item_share_permissions.to_dict())
            _dict['sharePermissions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PermissionDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "editPermissions": [SharePermission.from_dict(_item) for _item in obj["editPermissions"]] if obj.get("editPermissions") is not None else None,
            "sharePermissions": [SharePermission.from_dict(_item) for _item in obj["sharePermissions"]] if obj.get("sharePermissions") is not None else None
        })
        return _obj


