# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class PermissionGrantDTO(BaseModel):
    """
    List of permission grants
    """ # noqa: E501
    application_access: Optional[List[StrictStr]] = Field(default=None, alias="applicationAccess")
    group_custom_fields: Optional[List[ProjectCreateResourceIdentifier]] = Field(default=None, alias="groupCustomFields")
    groups: Optional[List[ProjectCreateResourceIdentifier]] = None
    permission_keys: Optional[List[StrictStr]] = Field(default=None, alias="permissionKeys")
    project_roles: Optional[List[ProjectCreateResourceIdentifier]] = Field(default=None, alias="projectRoles")
    special_grants: Optional[List[StrictStr]] = Field(default=None, alias="specialGrants")
    user_custom_fields: Optional[List[ProjectCreateResourceIdentifier]] = Field(default=None, alias="userCustomFields")
    users: Optional[List[ProjectCreateResourceIdentifier]] = None
    __properties: ClassVar[List[str]] = ["applicationAccess", "groupCustomFields", "groups", "permissionKeys", "projectRoles", "specialGrants", "userCustomFields", "users"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PermissionGrantDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in group_custom_fields (list)
        _items = []
        if self.group_custom_fields:
            for _item_group_custom_fields in self.group_custom_fields:
                if _item_group_custom_fields:
                    _items.append(_item_group_custom_fields.to_dict())
            _dict['groupCustomFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in project_roles (list)
        _items = []
        if self.project_roles:
            for _item_project_roles in self.project_roles:
                if _item_project_roles:
                    _items.append(_item_project_roles.to_dict())
            _dict['projectRoles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in user_custom_fields (list)
        _items = []
        if self.user_custom_fields:
            for _item_user_custom_fields in self.user_custom_fields:
                if _item_user_custom_fields:
                    _items.append(_item_user_custom_fields.to_dict())
            _dict['userCustomFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PermissionGrantDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applicationAccess": obj.get("applicationAccess"),
            "groupCustomFields": [ProjectCreateResourceIdentifier.from_dict(_item) for _item in obj["groupCustomFields"]] if obj.get("groupCustomFields") is not None else None,
            "groups": [ProjectCreateResourceIdentifier.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "permissionKeys": obj.get("permissionKeys"),
            "projectRoles": [ProjectCreateResourceIdentifier.from_dict(_item) for _item in obj["projectRoles"]] if obj.get("projectRoles") is not None else None,
            "specialGrants": obj.get("specialGrants"),
            "userCustomFields": [ProjectCreateResourceIdentifier.from_dict(_item) for _item in obj["userCustomFields"]] if obj.get("userCustomFields") is not None else None,
            "users": [ProjectCreateResourceIdentifier.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None
        })
        return _obj


