# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.permission_grant_dto import PermissionGrantDTO
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class PermissionPayloadDTO(BaseModel):
    """
    The payload to create a permission scheme
    """ # noqa: E501
    add_addon_role: Optional[StrictBool] = Field(default=None, description="Configuration to generate addon role. Default is false if null. Only applies to GLOBAL-scoped permission scheme", alias="addAddonRole")
    description: Optional[StrictStr] = Field(default=None, description="The description of the permission scheme")
    grants: Optional[List[PermissionGrantDTO]] = Field(default=None, description="List of permission grants")
    name: Optional[StrictStr] = Field(default=None, description="The name of the permission scheme")
    on_conflict: Optional[StrictStr] = Field(default='FAIL', description="The strategy to use when there is a conflict with an existing permission scheme. FAIL - Fail execution, this always needs to be unique; USE - Use the existing entity and ignore new entity parameters; NEW - If the entity exist, try and create a new one with a different name", alias="onConflict")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    __properties: ClassVar[List[str]] = ["addAddonRole", "description", "grants", "name", "onConflict", "pcri"]

    @field_validator('on_conflict')
    def on_conflict_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'USE', 'NEW']):
            raise ValueError("must be one of enum values ('FAIL', 'USE', 'NEW')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PermissionPayloadDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in grants (list)
        _items = []
        if self.grants:
            for _item_grants in self.grants:
                if _item_grants:
                    _items.append(_item_grants.to_dict())
            _dict['grants'] = _items
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PermissionPayloadDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addAddonRole": obj.get("addAddonRole"),
            "description": obj.get("description"),
            "grants": [PermissionGrantDTO.from_dict(_item) for _item in obj["grants"]] if obj.get("grants") is not None else None,
            "name": obj.get("name"),
            "onConflict": obj.get("onConflict") if obj.get("onConflict") is not None else 'FAIL',
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None
        })
        return _obj


