# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.preview_rule_configuration import PreviewRuleConfiguration
from typing import Optional, Set
from typing_extensions import Self

class PreviewConditionGroupConfiguration(BaseModel):
    """
    Condition group configuration for workflow transitions.
    """ # noqa: E501
    condition_groups: Optional[List[Optional[PreviewConditionGroupConfiguration]]] = Field(default=None, description="The nested conditions of the condition group.", alias="conditionGroups")
    conditions: Optional[List[Optional[PreviewRuleConfiguration]]] = Field(default=None, description="The rules for this condition.")
    operation: Optional[StrictStr] = Field(default=None, description="Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.")
    __properties: ClassVar[List[str]] = ["conditionGroups", "conditions", "operation"]

    @field_validator('operation')
    def operation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ANY', 'ALL']):
            raise ValueError("must be one of enum values ('ANY', 'ALL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PreviewConditionGroupConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in condition_groups (list)
        _items = []
        if self.condition_groups:
            for _item_condition_groups in self.condition_groups:
                if _item_condition_groups:
                    _items.append(_item_condition_groups.to_dict())
            _dict['conditionGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict['conditions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PreviewConditionGroupConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "conditionGroups": [PreviewConditionGroupConfiguration.from_dict(_item) for _item in obj["conditionGroups"]] if obj.get("conditionGroups") is not None else None,
            "conditions": [PreviewRuleConfiguration.from_dict(_item) for _item in obj["conditions"]] if obj.get("conditions") is not None else None,
            "operation": obj.get("operation")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
PreviewConditionGroupConfiguration.model_rebuild(raise_errors=False)

