# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.page_bean_priority_with_sequence import PageBeanPriorityWithSequence
from devopso.clients.jira_cloud.models.page_bean_project_details import PageBeanProjectDetails
from typing import Optional, Set
from typing_extensions import Self

class PrioritySchemeWithPaginatedPrioritiesAndProjects(BaseModel):
    """
    A priority scheme with paginated priorities and projects.
    """ # noqa: E501
    default: Optional[StrictBool] = None
    default_priority_id: Optional[StrictStr] = Field(default=None, description="The ID of the default issue priority.", alias="defaultPriorityId")
    description: Optional[StrictStr] = Field(default=None, description="The description of the priority scheme")
    id: StrictStr = Field(description="The ID of the priority scheme.")
    is_default: Optional[StrictBool] = Field(default=None, alias="isDefault")
    name: StrictStr = Field(description="The name of the priority scheme")
    priorities: Optional[PageBeanPriorityWithSequence] = Field(default=None, description="The paginated list of priorities.")
    projects: Optional[PageBeanProjectDetails] = Field(default=None, description="The paginated list of projects.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the priority scheme.", alias="self")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["default", "defaultPriorityId", "description", "id", "isDefault", "name", "priorities", "projects", "self"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrioritySchemeWithPaginatedPrioritiesAndProjects from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of priorities
        if self.priorities:
            _dict['priorities'] = self.priorities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of projects
        if self.projects:
            _dict['projects'] = self.projects.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrioritySchemeWithPaginatedPrioritiesAndProjects from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "default": obj.get("default"),
            "defaultPriorityId": obj.get("defaultPriorityId"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "isDefault": obj.get("isDefault"),
            "name": obj.get("name"),
            "priorities": PageBeanPriorityWithSequence.from_dict(obj["priorities"]) if obj.get("priorities") is not None else None,
            "projects": PageBeanProjectDetails.from_dict(obj["projects"]) if obj.get("projects") is not None else None,
            "self": obj.get("self")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


