# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.avatar_urls_bean import AvatarUrlsBean
from devopso.clients.jira_cloud.models.updated_project_category import UpdatedProjectCategory
from typing import Optional, Set
from typing_extensions import Self

class ProjectDetails(BaseModel):
    """
    Details about a project.
    """ # noqa: E501
    avatar_urls: Optional[AvatarUrlsBean] = Field(default=None, description="The URLs of the project's avatars.", alias="avatarUrls")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the project.")
    key: Optional[StrictStr] = Field(default=None, description="The key of the project.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the project.")
    project_category: Optional[UpdatedProjectCategory] = Field(default=None, description="The category the project belongs to.", alias="projectCategory")
    project_type_key: Optional[StrictStr] = Field(default=None, description="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.", alias="projectTypeKey")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the project details.", alias="self")
    simplified: Optional[StrictBool] = Field(default=None, description="Whether or not the project is simplified.")
    __properties: ClassVar[List[str]] = ["avatarUrls", "id", "key", "name", "projectCategory", "projectTypeKey", "self", "simplified"]

    @field_validator('project_type_key')
    def project_type_key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['software', 'service_desk', 'business']):
            raise ValueError("must be one of enum values ('software', 'service_desk', 'business')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "avatar_urls",
            "key",
            "name",
            "project_category",
            "project_type_key",
            "var_self",
            "simplified",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of avatar_urls
        if self.avatar_urls:
            _dict['avatarUrls'] = self.avatar_urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_category
        if self.project_category:
            _dict['projectCategory'] = self.project_category.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatarUrls": AvatarUrlsBean.from_dict(obj["avatarUrls"]) if obj.get("avatarUrls") is not None else None,
            "id": obj.get("id"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "projectCategory": UpdatedProjectCategory.from_dict(obj["projectCategory"]) if obj.get("projectCategory") is not None else None,
            "projectTypeKey": obj.get("projectTypeKey"),
            "self": obj.get("self"),
            "simplified": obj.get("simplified")
        })
        return _obj


