# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.avatar_urls_bean import AvatarUrlsBean
from devopso.clients.jira_cloud.models.issue_type_issue_create_metadata import IssueTypeIssueCreateMetadata
from typing import Optional, Set
from typing_extensions import Self

class ProjectIssueCreateMetadata(BaseModel):
    """
    Details of the issue creation metadata for a project.
    """ # noqa: E501
    avatar_urls: Optional[AvatarUrlsBean] = Field(default=None, description="List of the project's avatars, returning the avatar size and associated URL.", alias="avatarUrls")
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional project issue create metadata details in the response.")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the project.")
    issuetypes: Optional[List[IssueTypeIssueCreateMetadata]] = Field(default=None, description="List of the issue types supported by the project.")
    key: Optional[StrictStr] = Field(default=None, description="The key of the project.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the project.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the project.", alias="self")
    __properties: ClassVar[List[str]] = ["avatarUrls", "expand", "id", "issuetypes", "key", "name", "self"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectIssueCreateMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "avatar_urls",
            "expand",
            "id",
            "issuetypes",
            "key",
            "name",
            "var_self",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of avatar_urls
        if self.avatar_urls:
            _dict['avatarUrls'] = self.avatar_urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in issuetypes (list)
        _items = []
        if self.issuetypes:
            for _item_issuetypes in self.issuetypes:
                if _item_issuetypes:
                    _items.append(_item_issuetypes.to_dict())
            _dict['issuetypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectIssueCreateMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatarUrls": AvatarUrlsBean.from_dict(obj["avatarUrls"]) if obj.get("avatarUrls") is not None else None,
            "expand": obj.get("expand"),
            "id": obj.get("id"),
            "issuetypes": [IssueTypeIssueCreateMetadata.from_dict(_item) for _item in obj["issuetypes"]] if obj.get("issuetypes") is not None else None,
            "key": obj.get("key"),
            "name": obj.get("name"),
            "self": obj.get("self")
        })
        return _obj


