# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_issue_types_hierarchy_level import ProjectIssueTypesHierarchyLevel
from typing import Optional, Set
from typing_extensions import Self

class ProjectIssueTypeHierarchy(BaseModel):
    """
    The hierarchy of issue types within a project.
    """ # noqa: E501
    hierarchy: Optional[List[ProjectIssueTypesHierarchyLevel]] = Field(default=None, description="Details of an issue type hierarchy level.")
    project_id: Optional[StrictInt] = Field(default=None, description="The ID of the project.", alias="projectId")
    __properties: ClassVar[List[str]] = ["hierarchy", "projectId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectIssueTypeHierarchy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "hierarchy",
            "project_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in hierarchy (list)
        _items = []
        if self.hierarchy:
            for _item_hierarchy in self.hierarchy:
                if _item_hierarchy:
                    _items.append(_item_hierarchy.to_dict())
            _dict['hierarchy'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectIssueTypeHierarchy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hierarchy": [ProjectIssueTypesHierarchyLevel.from_dict(_item) for _item in obj["hierarchy"]] if obj.get("hierarchy") is not None else None,
            "projectId": obj.get("projectId")
        })
        return _obj


