# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from devopso.clients.jira_cloud.models.issue_type_info import IssueTypeInfo
from typing import Optional, Set
from typing_extensions import Self

class ProjectIssueTypesHierarchyLevel(BaseModel):
    """
    Details of an issue type hierarchy level.
    """ # noqa: E501
    entity_id: Optional[UUID] = Field(default=None, description="The ID of the issue type hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).", alias="entityId")
    issue_types: Optional[List[IssueTypeInfo]] = Field(default=None, description="The list of issue types in the hierarchy level.", alias="issueTypes")
    level: Optional[StrictInt] = Field(default=None, description="The level of the issue type hierarchy level.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the issue type hierarchy level.")
    __properties: ClassVar[List[str]] = ["entityId", "issueTypes", "level", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectIssueTypesHierarchyLevel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "entity_id",
            "issue_types",
            "level",
            "name",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issue_types (list)
        _items = []
        if self.issue_types:
            for _item_issue_types in self.issue_types:
                if _item_issue_types:
                    _items.append(_item_issue_types.to_dict())
            _dict['issueTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectIssueTypesHierarchyLevel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "entityId": obj.get("entityId"),
            "issueTypes": [IssueTypeInfo.from_dict(_item) for _item in obj["issueTypes"]] if obj.get("issueTypes") is not None else None,
            "level": obj.get("level"),
            "name": obj.get("name")
        })
        return _obj


