# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class ProjectPayload(BaseModel):
    """
    The payload for creating a project
    """ # noqa: E501
    field_layout_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="fieldLayoutSchemeId")
    issue_security_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="issueSecuritySchemeId")
    issue_type_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="issueTypeSchemeId")
    issue_type_screen_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="issueTypeScreenSchemeId")
    notification_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="notificationSchemeId")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    permission_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="permissionSchemeId")
    project_type_key: Optional[StrictStr] = Field(default=None, description="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don't specify the project template you have to specify the project type.", alias="projectTypeKey")
    workflow_scheme_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="workflowSchemeId")
    __properties: ClassVar[List[str]] = ["fieldLayoutSchemeId", "issueSecuritySchemeId", "issueTypeSchemeId", "issueTypeScreenSchemeId", "notificationSchemeId", "pcri", "permissionSchemeId", "projectTypeKey", "workflowSchemeId"]

    @field_validator('project_type_key')
    def project_type_key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['software', 'business', 'service_desk', 'product_discovery']):
            raise ValueError("must be one of enum values ('software', 'business', 'service_desk', 'product_discovery')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of field_layout_scheme_id
        if self.field_layout_scheme_id:
            _dict['fieldLayoutSchemeId'] = self.field_layout_scheme_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue_security_scheme_id
        if self.issue_security_scheme_id:
            _dict['issueSecuritySchemeId'] = self.issue_security_scheme_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue_type_scheme_id
        if self.issue_type_scheme_id:
            _dict['issueTypeSchemeId'] = self.issue_type_scheme_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue_type_screen_scheme_id
        if self.issue_type_screen_scheme_id:
            _dict['issueTypeScreenSchemeId'] = self.issue_type_screen_scheme_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notification_scheme_id
        if self.notification_scheme_id:
            _dict['notificationSchemeId'] = self.notification_scheme_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permission_scheme_id
        if self.permission_scheme_id:
            _dict['permissionSchemeId'] = self.permission_scheme_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow_scheme_id
        if self.workflow_scheme_id:
            _dict['workflowSchemeId'] = self.workflow_scheme_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fieldLayoutSchemeId": ProjectCreateResourceIdentifier.from_dict(obj["fieldLayoutSchemeId"]) if obj.get("fieldLayoutSchemeId") is not None else None,
            "issueSecuritySchemeId": ProjectCreateResourceIdentifier.from_dict(obj["issueSecuritySchemeId"]) if obj.get("issueSecuritySchemeId") is not None else None,
            "issueTypeSchemeId": ProjectCreateResourceIdentifier.from_dict(obj["issueTypeSchemeId"]) if obj.get("issueTypeSchemeId") is not None else None,
            "issueTypeScreenSchemeId": ProjectCreateResourceIdentifier.from_dict(obj["issueTypeScreenSchemeId"]) if obj.get("issueTypeScreenSchemeId") is not None else None,
            "notificationSchemeId": ProjectCreateResourceIdentifier.from_dict(obj["notificationSchemeId"]) if obj.get("notificationSchemeId") is not None else None,
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None,
            "permissionSchemeId": ProjectCreateResourceIdentifier.from_dict(obj["permissionSchemeId"]) if obj.get("permissionSchemeId") is not None else None,
            "projectTypeKey": obj.get("projectTypeKey"),
            "workflowSchemeId": ProjectCreateResourceIdentifier.from_dict(obj["workflowSchemeId"]) if obj.get("workflowSchemeId") is not None else None
        })
        return _obj


