# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.role_actor import RoleActor
from devopso.clients.jira_cloud.models.scope import Scope
from typing import Optional, Set
from typing_extensions import Self

class ProjectRole(BaseModel):
    """
    Details about the roles in a project.
    """ # noqa: E501
    actors: Optional[List[RoleActor]] = Field(default=None, description="The list of users who act in this role.")
    admin: Optional[StrictBool] = Field(default=None, description="Whether this role is the admin role for the project.")
    current_user_role: Optional[StrictBool] = Field(default=None, description="Whether the calling user is part of this role.", alias="currentUserRole")
    default: Optional[StrictBool] = Field(default=None, description="Whether this role is the default role for the project")
    description: Optional[StrictStr] = Field(default=None, description="The description of the project role.")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the project role.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the project role.")
    role_configurable: Optional[StrictBool] = Field(default=None, description="Whether the roles are configurable for this project.", alias="roleConfigurable")
    scope: Optional[Scope] = Field(default=None, description="The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL the project role details.", alias="self")
    translated_name: Optional[StrictStr] = Field(default=None, description="The translated name of the project role.", alias="translatedName")
    __properties: ClassVar[List[str]] = ["actors", "admin", "currentUserRole", "default", "description", "id", "name", "roleConfigurable", "scope", "self", "translatedName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "actors",
            "admin",
            "default",
            "description",
            "id",
            "role_configurable",
            "scope",
            "var_self",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in actors (list)
        _items = []
        if self.actors:
            for _item_actors in self.actors:
                if _item_actors:
                    _items.append(_item_actors.to_dict())
            _dict['actors'] = _items
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actors": [RoleActor.from_dict(_item) for _item in obj["actors"]] if obj.get("actors") is not None else None,
            "admin": obj.get("admin"),
            "currentUserRole": obj.get("currentUserRole"),
            "default": obj.get("default"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "roleConfigurable": obj.get("roleConfigurable"),
            "scope": Scope.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "self": obj.get("self"),
            "translatedName": obj.get("translatedName")
        })
        return _obj


