# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.custom_template_options import CustomTemplateOptions
from devopso.clients.jira_cloud.models.project_archetype import ProjectArchetype
from devopso.clients.jira_cloud.models.project_template_key import ProjectTemplateKey
from typing import Optional, Set
from typing_extensions import Self

class ProjectTemplateModel(BaseModel):
    """
    ProjectTemplateModel
    """ # noqa: E501
    archetype: Optional[ProjectArchetype] = None
    default_board_view: Optional[StrictStr] = Field(default=None, alias="defaultBoardView")
    description: Optional[StrictStr] = None
    live_template_project_id_reference: Optional[StrictInt] = Field(default=None, alias="liveTemplateProjectIdReference")
    name: Optional[StrictStr] = None
    project_template_key: Optional[ProjectTemplateKey] = Field(default=None, alias="projectTemplateKey")
    snapshot_template: Optional[Dict[str, Any]] = Field(default=None, alias="snapshotTemplate")
    template_generation_options: Optional[CustomTemplateOptions] = Field(default=None, alias="templateGenerationOptions")
    type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["archetype", "defaultBoardView", "description", "liveTemplateProjectIdReference", "name", "projectTemplateKey", "snapshotTemplate", "templateGenerationOptions", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LIVE', 'SNAPSHOT']):
            raise ValueError("must be one of enum values ('LIVE', 'SNAPSHOT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectTemplateModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of archetype
        if self.archetype:
            _dict['archetype'] = self.archetype.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_template_key
        if self.project_template_key:
            _dict['projectTemplateKey'] = self.project_template_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of template_generation_options
        if self.template_generation_options:
            _dict['templateGenerationOptions'] = self.template_generation_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectTemplateModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "archetype": ProjectArchetype.from_dict(obj["archetype"]) if obj.get("archetype") is not None else None,
            "defaultBoardView": obj.get("defaultBoardView"),
            "description": obj.get("description"),
            "liveTemplateProjectIdReference": obj.get("liveTemplateProjectIdReference"),
            "name": obj.get("name"),
            "projectTemplateKey": ProjectTemplateKey.from_dict(obj["projectTemplateKey"]) if obj.get("projectTemplateKey") is not None else None,
            "snapshotTemplate": obj.get("snapshotTemplate"),
            "templateGenerationOptions": CustomTemplateOptions.from_dict(obj["templateGenerationOptions"]) if obj.get("templateGenerationOptions") is not None else None,
            "type": obj.get("type")
        })
        return _obj


