# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.application import Application
from devopso.clients.jira_cloud.models.remote_object import RemoteObject
from typing import Optional, Set
from typing_extensions import Self

class RemoteIssueLink(BaseModel):
    """
    Details of an issue remote link.
    """ # noqa: E501
    application: Optional[Application] = Field(default=None, description="Details of the remote application the linked item is in.")
    global_id: Optional[StrictStr] = Field(default=None, description="The global ID of the link, such as the ID of the item on the remote system.", alias="globalId")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the link.")
    object: Optional[RemoteObject] = Field(default=None, description="Details of the item linked to.")
    relationship: Optional[StrictStr] = Field(default=None, description="Description of the relationship between the issue and the linked item.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the link.", alias="self")
    __properties: ClassVar[List[str]] = ["application", "globalId", "id", "object", "relationship", "self"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RemoteIssueLink from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of application
        if self.application:
            _dict['application'] = self.application.to_dict()
        # override the default output from pydantic by calling `to_dict()` of object
        if self.object:
            _dict['object'] = self.object.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RemoteIssueLink from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "application": Application.from_dict(obj["application"]) if obj.get("application") is not None else None,
            "globalId": obj.get("globalId"),
            "id": obj.get("id"),
            "object": RemoteObject.from_dict(obj["object"]) if obj.get("object") is not None else None,
            "relationship": obj.get("relationship"),
            "self": obj.get("self")
        })
        return _obj


