# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.simple_error_collection import SimpleErrorCollection
from typing import Optional, Set
from typing_extensions import Self

class RemoveOptionFromIssuesResult(BaseModel):
    """
    RemoveOptionFromIssuesResult
    """ # noqa: E501
    errors: Optional[SimpleErrorCollection] = Field(default=None, description="A collection of errors related to unchanged issues. The collection size is limited, which means not all errors may be returned.")
    modified_issues: Optional[List[StrictInt]] = Field(default=None, description="The IDs of the modified issues.", alias="modifiedIssues")
    unmodified_issues: Optional[List[StrictInt]] = Field(default=None, description="The IDs of the unchanged issues, those issues where errors prevent modification.", alias="unmodifiedIssues")
    __properties: ClassVar[List[str]] = ["errors", "modifiedIssues", "unmodifiedIssues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RemoveOptionFromIssuesResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors'] = self.errors.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RemoveOptionFromIssuesResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errors": SimpleErrorCollection.from_dict(obj["errors"]) if obj.get("errors") is not None else None,
            "modifiedIssues": obj.get("modifiedIssues"),
            "unmodifiedIssues": obj.get("unmodifiedIssues")
        })
        return _obj


