# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_role_group import ProjectRoleGroup
from devopso.clients.jira_cloud.models.project_role_user import ProjectRoleUser
from typing import Optional, Set
from typing_extensions import Self

class RoleActor(BaseModel):
    """
    Details about a user assigned to a project role.
    """ # noqa: E501
    actor_group: Optional[ProjectRoleGroup] = Field(default=None, alias="actorGroup")
    actor_user: Optional[ProjectRoleUser] = Field(default=None, alias="actorUser")
    avatar_url: Optional[StrictStr] = Field(default=None, description="The avatar of the role actor.", alias="avatarUrl")
    display_name: Optional[StrictStr] = Field(default=None, description="The display name of the role actor. For users, depending on the user’s privacy setting, this may return an alternative value for the user's name.", alias="displayName")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the role actor.")
    name: Optional[StrictStr] = Field(default=None, description="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    type: Optional[StrictStr] = Field(default=None, description="The type of role actor.")
    __properties: ClassVar[List[str]] = ["actorGroup", "actorUser", "avatarUrl", "displayName", "id", "name", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['atlassian-group-role-actor', 'atlassian-user-role-actor']):
            raise ValueError("must be one of enum values ('atlassian-group-role-actor', 'atlassian-user-role-actor')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RoleActor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "actor_group",
            "actor_user",
            "avatar_url",
            "display_name",
            "id",
            "name",
            "type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor_group
        if self.actor_group:
            _dict['actorGroup'] = self.actor_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actor_user
        if self.actor_user:
            _dict['actorUser'] = self.actor_user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RoleActor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actorGroup": ProjectRoleGroup.from_dict(obj["actorGroup"]) if obj.get("actorGroup") is not None else None,
            "actorUser": ProjectRoleUser.from_dict(obj["actorUser"]) if obj.get("actorUser") is not None else None,
            "avatarUrl": obj.get("avatarUrl"),
            "displayName": obj.get("displayName"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type")
        })
        return _obj


