# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class RolePayload(BaseModel):
    """
    The payload used to create a project role. It is optional for CMP projects, as a default role actor will be provided. TMP will add new role actors to the table.
    """ # noqa: E501
    default_actors: Optional[List[ProjectCreateResourceIdentifier]] = Field(default=None, description="The default actors for the role. By adding default actors, the role will be added to any future projects created", alias="defaultActors")
    description: Optional[StrictStr] = Field(default=None, description="The description of the role")
    name: Optional[StrictStr] = Field(default=None, description="The name of the role")
    on_conflict: Optional[StrictStr] = Field(default='USE', description="The strategy to use when there is a conflict with an existing project role. FAIL - Fail execution, this always needs to be unique; USE - Use the existing entity and ignore new entity parameters", alias="onConflict")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    type: Optional[StrictStr] = Field(default=None, description="The type of the role. Only used by project-scoped project")
    __properties: ClassVar[List[str]] = ["defaultActors", "description", "name", "onConflict", "pcri", "type"]

    @field_validator('on_conflict')
    def on_conflict_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'USE', 'NEW']):
            raise ValueError("must be one of enum values ('FAIL', 'USE', 'NEW')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['HIDDEN', 'VIEWABLE', 'EDITABLE']):
            raise ValueError("must be one of enum values ('HIDDEN', 'VIEWABLE', 'EDITABLE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RolePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in default_actors (list)
        _items = []
        if self.default_actors:
            for _item_default_actors in self.default_actors:
                if _item_default_actors:
                    _items.append(_item_default_actors.to_dict())
            _dict['defaultActors'] = _items
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RolePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultActors": [ProjectCreateResourceIdentifier.from_dict(_item) for _item in obj["defaultActors"]] if obj.get("defaultActors") is not None else None,
            "description": obj.get("description"),
            "name": obj.get("name"),
            "onConflict": obj.get("onConflict") if obj.get("onConflict") is not None else 'USE',
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None,
            "type": obj.get("type")
        })
        return _obj


