# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.security_level_member_payload import SecurityLevelMemberPayload
from typing import Optional, Set
from typing_extensions import Self

class SecurityLevelPayload(BaseModel):
    """
    The payload for creating a security level. See https://support.atlassian.com/jira-cloud-administration/docs/configure-issue-security-schemes/
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the security level")
    is_default: Optional[StrictBool] = Field(default=None, description="Whether the security level is default for the security scheme", alias="isDefault")
    name: Optional[StrictStr] = Field(default=None, description="The name of the security level")
    security_level_members: Optional[List[SecurityLevelMemberPayload]] = Field(default=None, description="The members of the security level", alias="securityLevelMembers")
    __properties: ClassVar[List[str]] = ["description", "isDefault", "name", "securityLevelMembers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecurityLevelPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in security_level_members (list)
        _items = []
        if self.security_level_members:
            for _item_security_level_members in self.security_level_members:
                if _item_security_level_members:
                    _items.append(_item_security_level_members.to_dict())
            _dict['securityLevelMembers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecurityLevelPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "isDefault": obj.get("isDefault"),
            "name": obj.get("name"),
            "securityLevelMembers": [SecurityLevelMemberPayload.from_dict(_item) for _item in obj["securityLevelMembers"]] if obj.get("securityLevelMembers") is not None else None
        })
        return _obj


