# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.health_check_result import HealthCheckResult
from typing import Optional, Set
from typing_extensions import Self

class ServerInformation(BaseModel):
    """
    Details about the Jira instance.
    """ # noqa: E501
    base_url: Optional[StrictStr] = Field(default=None, description="The base URL of the Jira instance.", alias="baseUrl")
    build_date: Optional[datetime] = Field(default=None, description="The timestamp when the Jira version was built.", alias="buildDate")
    build_number: Optional[StrictInt] = Field(default=None, description="The build number of the Jira version.", alias="buildNumber")
    deployment_type: Optional[StrictStr] = Field(default=None, description="The type of server deployment. This is always returned as *Cloud*.", alias="deploymentType")
    display_url: Optional[StrictStr] = Field(default=None, description="The display URL of the Jira instance.", alias="displayUrl")
    display_url_confluence: Optional[StrictStr] = Field(default=None, description="The display URL of Confluence.", alias="displayUrlConfluence")
    display_url_servicedesk_help_center: Optional[StrictStr] = Field(default=None, description="The display URL of the Servicedesk Help Center.", alias="displayUrlServicedeskHelpCenter")
    health_checks: Optional[List[HealthCheckResult]] = Field(default=None, description="Jira instance health check results. Deprecated and no longer returned.", alias="healthChecks")
    scm_info: Optional[StrictStr] = Field(default=None, description="The unique identifier of the Jira version.", alias="scmInfo")
    server_time: Optional[datetime] = Field(default=None, description="The time in Jira when this request was responded to.", alias="serverTime")
    server_time_zone: Optional[StrictStr] = Field(default=None, description="The default timezone of the Jira server. In a format known as Olson Time Zones, IANA Time Zones or TZ Database Time Zones.", alias="serverTimeZone")
    server_title: Optional[StrictStr] = Field(default=None, description="The name of the Jira instance.", alias="serverTitle")
    version: Optional[StrictStr] = Field(default=None, description="The version of Jira.")
    version_numbers: Optional[List[StrictInt]] = Field(default=None, description="The major, minor, and revision version numbers of the Jira version.", alias="versionNumbers")
    __properties: ClassVar[List[str]] = ["baseUrl", "buildDate", "buildNumber", "deploymentType", "displayUrl", "displayUrlConfluence", "displayUrlServicedeskHelpCenter", "healthChecks", "scmInfo", "serverTime", "serverTimeZone", "serverTitle", "version", "versionNumbers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServerInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in health_checks (list)
        _items = []
        if self.health_checks:
            for _item_health_checks in self.health_checks:
                if _item_health_checks:
                    _items.append(_item_health_checks.to_dict())
            _dict['healthChecks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServerInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "baseUrl": obj.get("baseUrl"),
            "buildDate": obj.get("buildDate"),
            "buildNumber": obj.get("buildNumber"),
            "deploymentType": obj.get("deploymentType"),
            "displayUrl": obj.get("displayUrl"),
            "displayUrlConfluence": obj.get("displayUrlConfluence"),
            "displayUrlServicedeskHelpCenter": obj.get("displayUrlServicedeskHelpCenter"),
            "healthChecks": [HealthCheckResult.from_dict(_item) for _item in obj["healthChecks"]] if obj.get("healthChecks") is not None else None,
            "scmInfo": obj.get("scmInfo"),
            "serverTime": obj.get("serverTime"),
            "serverTimeZone": obj.get("serverTimeZone"),
            "serverTitle": obj.get("serverTitle"),
            "version": obj.get("version"),
            "versionNumbers": obj.get("versionNumbers")
        })
        return _obj


