# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SharePermissionInputBean(BaseModel):
    """
    SharePermissionInputBean
    """ # noqa: E501
    account_id: Optional[StrictStr] = Field(default=None, description="The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.", alias="accountId")
    group_id: Optional[StrictStr] = Field(default=None, description="The ID of the group, which uniquely identifies the group across all Atlassian products.For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*. Cannot be provided with `groupname`.", alias="groupId")
    groupname: Optional[StrictStr] = Field(default=None, description="The name of the group to share the filter with. Set `type` to `group`. Please note that the name of a group is mutable, to reliably identify a group use `groupId`.")
    project_id: Optional[StrictStr] = Field(default=None, description="The ID of the project to share the filter with. Set `type` to `project`.", alias="projectId")
    project_role_id: Optional[StrictStr] = Field(default=None, description="The ID of the project role to share the filter with. Set `type` to `projectRole` and the `projectId` for the project that the role is in.", alias="projectRoleId")
    rights: Optional[StrictInt] = Field(default=None, description="The rights for the share permission.")
    type: StrictStr = Field(description="The type of the share permission.Specify the type as follows:   *  `user` Share with a user.  *  `group` Share with a group. Specify `groupname` as well.  *  `project` Share with a project. Specify `projectId` as well.  *  `projectRole` Share with a project role in a project. Specify `projectId` and `projectRoleId` as well.  *  `global` Share globally, including anonymous users. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.  *  `authenticated` Share with all logged-in users. This shows as `loggedin` in the response. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.")
    __properties: ClassVar[List[str]] = ["accountId", "groupId", "groupname", "projectId", "projectRoleId", "rights", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['user', 'project', 'group', 'projectRole', 'global', 'authenticated']):
            raise ValueError("must be one of enum values ('user', 'project', 'group', 'projectRole', 'global', 'authenticated')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SharePermissionInputBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SharePermissionInputBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "groupId": obj.get("groupId"),
            "groupname": obj.get("groupname"),
            "projectId": obj.get("projectId"),
            "projectRoleId": obj.get("projectRoleId"),
            "rights": obj.get("rights"),
            "type": obj.get("type")
        })
        return _obj


