# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class SimplifiedHierarchyLevel(BaseModel):
    """
    SimplifiedHierarchyLevel
    """ # noqa: E501
    above_level_id: Optional[StrictInt] = Field(default=None, description="The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).", alias="aboveLevelId")
    below_level_id: Optional[StrictInt] = Field(default=None, description="The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).", alias="belowLevelId")
    external_uuid: Optional[UUID] = Field(default=None, description="The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).", alias="externalUuid")
    hierarchy_level_number: Optional[StrictInt] = Field(default=None, alias="hierarchyLevelNumber")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).")
    issue_type_ids: Optional[List[StrictInt]] = Field(default=None, description="The issue types available in this hierarchy level.", alias="issueTypeIds")
    level: Optional[StrictInt] = Field(default=None, description="The level of this item in the hierarchy.")
    name: Optional[StrictStr] = Field(default=None, description="The name of this hierarchy level.")
    project_configuration_id: Optional[StrictInt] = Field(default=None, description="The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).", alias="projectConfigurationId")
    __properties: ClassVar[List[str]] = ["aboveLevelId", "belowLevelId", "externalUuid", "hierarchyLevelNumber", "id", "issueTypeIds", "level", "name", "projectConfigurationId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SimplifiedHierarchyLevel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SimplifiedHierarchyLevel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aboveLevelId": obj.get("aboveLevelId"),
            "belowLevelId": obj.get("belowLevelId"),
            "externalUuid": obj.get("externalUuid"),
            "hierarchyLevelNumber": obj.get("hierarchyLevelNumber"),
            "id": obj.get("id"),
            "issueTypeIds": obj.get("issueTypeIds"),
            "level": obj.get("level"),
            "name": obj.get("name"),
            "projectConfigurationId": obj.get("projectConfigurationId")
        })
        return _obj


