# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from uuid import UUID
from devopso.clients.jira_cloud.models.content_item import ContentItem
from devopso.clients.jira_cloud.models.redaction_position import RedactionPosition
from typing import Optional, Set
from typing_extensions import Self

class SingleRedactionRequest(BaseModel):
    """
    SingleRedactionRequest
    """ # noqa: E501
    content_item: ContentItem = Field(alias="contentItem")
    external_id: UUID = Field(description="Unique id for the redaction request; ID format should be of UUID", alias="externalId")
    reason: StrictStr = Field(description="The reason why the content is being redacted")
    redaction_position: RedactionPosition = Field(alias="redactionPosition")
    __properties: ClassVar[List[str]] = ["contentItem", "externalId", "reason", "redactionPosition"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SingleRedactionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content_item
        if self.content_item:
            _dict['contentItem'] = self.content_item.to_dict()
        # override the default output from pydantic by calling `to_dict()` of redaction_position
        if self.redaction_position:
            _dict['redactionPosition'] = self.redaction_position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SingleRedactionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contentItem": ContentItem.from_dict(obj["contentItem"]) if obj.get("contentItem") is not None else None,
            "externalId": obj.get("externalId"),
            "reason": obj.get("reason"),
            "redactionPosition": RedactionPosition.from_dict(obj["redactionPosition"]) if obj.get("redactionPosition") is not None else None
        })
        return _obj


