# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SuggestedIssue(BaseModel):
    """
    An issue suggested for use in the issue picker auto-completion.
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The ID of the issue.")
    img: Optional[StrictStr] = Field(default=None, description="The URL of the issue type's avatar.")
    key: Optional[StrictStr] = Field(default=None, description="The key of the issue.")
    key_html: Optional[StrictStr] = Field(default=None, description="The key of the issue in HTML format.", alias="keyHtml")
    summary: Optional[StrictStr] = Field(default=None, description="The phrase containing the query string in HTML format, with the string highlighted with HTML bold tags.")
    summary_text: Optional[StrictStr] = Field(default=None, description="The phrase containing the query string, as plain text.", alias="summaryText")
    __properties: ClassVar[List[str]] = ["id", "img", "key", "keyHtml", "summary", "summaryText"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SuggestedIssue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "img",
            "key",
            "key_html",
            "summary",
            "summary_text",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SuggestedIssue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "img": obj.get("img"),
            "key": obj.get("key"),
            "keyHtml": obj.get("keyHtml"),
            "summary": obj.get("summary"),
            "summaryText": obj.get("summaryText")
        })
        return _obj


