# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.suggested_mappings_for_priorities_request_bean import SuggestedMappingsForPrioritiesRequestBean
from devopso.clients.jira_cloud.models.suggested_mappings_for_projects_request_bean import SuggestedMappingsForProjectsRequestBean
from typing import Optional, Set
from typing_extensions import Self

class SuggestedMappingsRequestBean(BaseModel):
    """
    Details of changes to a priority scheme that require suggested priority mappings.
    """ # noqa: E501
    max_results: Optional[StrictInt] = Field(default=None, description="The maximum number of results that could be on the page.", alias="maxResults")
    priorities: Optional[SuggestedMappingsForPrioritiesRequestBean] = Field(default=None, description="The priority changes in the scheme.")
    projects: Optional[SuggestedMappingsForProjectsRequestBean] = Field(default=None, description="The project changes in the scheme.")
    scheme_id: Optional[StrictInt] = Field(default=None, description="The id of the priority scheme.", alias="schemeId")
    start_at: Optional[StrictInt] = Field(default=None, description="The index of the first item returned on the page.", alias="startAt")
    __properties: ClassVar[List[str]] = ["maxResults", "priorities", "projects", "schemeId", "startAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SuggestedMappingsRequestBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of priorities
        if self.priorities:
            _dict['priorities'] = self.priorities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of projects
        if self.projects:
            _dict['projects'] = self.projects.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SuggestedMappingsRequestBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "maxResults": obj.get("maxResults"),
            "priorities": SuggestedMappingsForPrioritiesRequestBean.from_dict(obj["priorities"]) if obj.get("priorities") is not None else None,
            "projects": SuggestedMappingsForProjectsRequestBean.from_dict(obj["projects"]) if obj.get("projects") is not None else None,
            "schemeId": obj.get("schemeId"),
            "startAt": obj.get("startAt")
        })
        return _obj


